/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.BadgeCounterRequest;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.Utils.TokenUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONException;
import org.json.JSONObject;

public class GetUnreadMessagesCountCommand
implements Command {
    public static final String TAG = "GetUnreadMessagesCountCommand";
    private static final String PUSHER_BADGE_URL = "https://%s/api/account/%s/device/push?appId=%s&lpid=%s&jwt=%s";
    private static final String BADGE_SEQUENCE = "badge_sequence";
    private static final String BADGE_COUNT = "badge_count";
    private static final String BADGE_TIMESTAMP = "badge_timestamp";
    private static final String BADGE_CONVERSATION_ID = "badge_conversation_id";
    private static final long BADGE_LAST_TIMESTAMP_THRESHOLD = 10000L;
    private final Messaging mController;
    private String mBrandId;
    private ICallback<Integer, Exception> mCallback;
    private String mAppId;
    private String mPusherDomain;
    private PreferenceManager mPreferenceManager;
    private String mLocalToken;

    public GetUnreadMessagesCountCommand(Messaging messagingController, String brandId, String appId, ICallback<Integer, Exception> callback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.mCallback = callback;
        this.mPreferenceManager = PreferenceManager.getInstance();
    }

    public void execute() {
        if (!this.isBadgeThresholdWasPassed(this.mBrandId)) {
            LPMobileLog.d((String)TAG, (String)"Time threshold was not passed yet. Return cached data");
            this.returnCachedDetails();
        } else {
            String consumerId;
            LPMobileLog.d((String)TAG, (String)"Time threshold was passed");
            if (this.mController.mAccountsController.getAccount(this.mBrandId) == null) {
                this.mLocalToken = this.getTokenFromSharedPreferences();
                if (TokenUtils.isJwtExpired(this.mLocalToken)) {
                    this.sendTokenExpired();
                    return;
                }
            } else if (this.mController.mAccountsController.isTokenExpired(this.mBrandId)) {
                this.sendTokenExpired();
                return;
            }
            LPMobileLog.d((String)TAG, (String)"JWT is valid - send request to Pusher");
            this.mPusherDomain = this.mController.mAccountsController.getServiceUrl(this.mBrandId, "pusher");
            if (TextUtils.isEmpty((CharSequence)this.mPusherDomain)) {
                this.mPusherDomain = PreferenceManager.getInstance().getStringValue("pusher", this.mBrandId, null);
                if (TextUtils.isEmpty((CharSequence)this.mPusherDomain)) {
                    this.returnCachedDetails();
                    return;
                }
            }
            if (TextUtils.isEmpty((CharSequence)(consumerId = this.mController.amsUsers.getConsumerId(this.mBrandId)))) {
                LPMobileLog.d((String)TAG, (String)"execute: consumerId is not available. Trying to get from DB...");
                this.mController.amsUsers.getConsumerByBrandIDFromDB(this.mBrandId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<String>(){

                    public void onResult(String returnedConsumerId) {
                        if (returnedConsumerId != null && !TextUtils.isEmpty((CharSequence)returnedConsumerId)) {
                            GetUnreadMessagesCountCommand.this.validateStateAndSendRequest(GetUnreadMessagesCountCommand.this.mPusherDomain, returnedConsumerId);
                            LPMobileLog.d((String)GetUnreadMessagesCountCommand.TAG, (String)("onResult: got  consumerId from DB (" + returnedConsumerId + "). get the badge counter with it..."));
                        } else {
                            LPMobileLog.w((String)GetUnreadMessagesCountCommand.TAG, (String)"onResult: Cannot get user profile from DB. Quit get badge counter");
                            GetUnreadMessagesCountCommand.this.mCallback.onError((Throwable)new Exception("Error: failed to get the user profile, canceling badge request"));
                        }
                    }
                }).execute();
            } else {
                this.validateStateAndSendRequest(this.mPusherDomain, consumerId);
            }
        }
    }

    private String getTokenFromSharedPreferences() {
        String token;
        String decryptedToken = this.mPreferenceManager.getStringValue("account_token_enc", this.mBrandId, null);
        if (TextUtils.isEmpty((CharSequence)decryptedToken)) {
            token = this.mPreferenceManager.getStringValue("account_token", this.mBrandId, null);
            this.mPreferenceManager.remove("account_token", this.mBrandId);
        } else {
            token = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedToken);
        }
        return token;
    }

    private void sendTokenExpired() {
        LPMobileLog.d((String)TAG, (String)"JWT is expired - calling to onTokenExpired callback");
        this.mController.mEventsProxy.onTokenExpired();
        this.mCallback.onError((Throwable)new Exception("Error: Token expired, refresh the token and try again"));
    }

    private void validateCounterWithSequence(final String convId, final int pushSequence, final int pushBadgeCounter) {
        LPMobileLog.d((String)TAG, (String)("Conversation ID: " + convId + " Sequence " + pushSequence + " counter " + pushBadgeCounter));
        this.mController.amsDialogs.queryOpenDialogsOfConversation(convId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<ArrayList<Dialog>>(){

            public void onResult(ArrayList<Dialog> dialogs) {
                if (dialogs != null && dialogs.size() > 0) {
                    Dialog dialog = dialogs.get(0);
                    LPMobileLog.d((String)GetUnreadMessagesCountCommand.TAG, (String)("validateCounterWithSequence: found open dialog (" + dialog.getDialogId() + ") for conversion " + convId));
                    if (dialog.getLastServerSequence() > pushSequence) {
                        LPMobileLog.d((String)GetUnreadMessagesCountCommand.TAG, (String)("Local opened dialog sequence: " + dialog.getLastServerSequence() + " remote sequence: " + pushSequence));
                        GetUnreadMessagesCountCommand.this.updateCachedDetails(convId, dialog.getLastServerSequence(), 0);
                        GetUnreadMessagesCountCommand.this.notifySuccess(0);
                        return;
                    }
                    LPMobileLog.d((String)GetUnreadMessagesCountCommand.TAG, (String)("Local opened dialog sequence: " + dialog.getLastServerSequence() + " remote sequence: " + pushSequence + ": returning unread counter = " + pushBadgeCounter));
                    GetUnreadMessagesCountCommand.this.updateCachedDetails(convId, pushSequence, pushBadgeCounter);
                    GetUnreadMessagesCountCommand.this.notifySuccess(pushBadgeCounter);
                    return;
                }
                LPMobileLog.d((String)GetUnreadMessagesCountCommand.TAG, (String)("validateCounterWithSequence: no active dialog for the conversation " + convId + ". Set counter to 0"));
                GetUnreadMessagesCountCommand.this.updateCachedDetails(convId, pushSequence, 0);
                GetUnreadMessagesCountCommand.this.notifySuccess(0);
            }
        }).execute();
    }

    private void notifySuccess(final int counter) {
        if (this.mCallback != null) {
            Infra.instance.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    GetUnreadMessagesCountCommand.this.mCallback.onSuccess((Object)counter);
                }
            });
        }
    }

    private void notifyError(final Exception exception) {
        if (this.mCallback != null) {
            Infra.instance.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (exception instanceof SSLPeerUnverifiedException) {
                        ((GetUnreadMessagesCountCommand)GetUnreadMessagesCountCommand.this).mController.mEventsProxy.onError(TaskType.INVALID_CERTIFICATE, exception.getMessage());
                    }
                    GetUnreadMessagesCountCommand.this.mCallback.onError((Throwable)exception);
                }
            });
        }
    }

    private void validateStateAndSendRequest(final String pusherDomain, final String consumerId) {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.sendRequest(pusherDomain, consumerId);
        } else {
            new SynchronizedInternetConnectionCallback(new Runnable(){

                @Override
                public void run() {
                    GetUnreadMessagesCountCommand.this.sendRequest(pusherDomain, consumerId);
                }
            }).execute();
        }
    }

    private String buildPusherURL(String pusherDomain, String consumerId) {
        String token = this.mController.mAccountsController.getToken(this.mBrandId);
        if (token == null) {
            token = this.mLocalToken;
        }
        String pusherURL = String.format(PUSHER_BADGE_URL, pusherDomain, this.mBrandId, this.mAppId, consumerId, token);
        return pusherURL;
    }

    private void sendRequest(String pusherURL, String consumerId) {
        pusherURL = this.buildPusherURL(pusherURL, consumerId);
        List<String> certificates = this.mController.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        new BadgeCounterRequest(pusherURL, certificates, (ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String json) {
                if (!TextUtils.isEmpty((CharSequence)json)) {
                    try {
                        LPMobileLog.i((String)GetUnreadMessagesCountCommand.TAG, (String)("Unread response " + json));
                        JSONObject badgeObj = new JSONObject(json);
                        String conversationId = badgeObj.optString("conversationId");
                        int sequence = badgeObj.optInt("sequence");
                        int counter = badgeObj.optInt("badge");
                        GetUnreadMessagesCountCommand.this.validateCounterWithSequence(conversationId, sequence, counter);
                    }
                    catch (JSONException e) {
                        GetUnreadMessagesCountCommand.this.notifyError((Exception)((Object)e));
                    }
                }
            }

            public void onError(Exception exception) {
                LPMobileLog.e((String)GetUnreadMessagesCountCommand.TAG, (String)("Error: response " + exception.getMessage()));
                GetUnreadMessagesCountCommand.this.notifyError(exception);
            }
        }).execute();
    }

    private void updateCachedDetails(String conversationId, int sequence, int counter) {
        PreferenceManager.getInstance().setLongValue(BADGE_TIMESTAMP, this.mBrandId, System.currentTimeMillis());
        PreferenceManager.getInstance().setStringValue(BADGE_CONVERSATION_ID, this.mBrandId, conversationId);
        PreferenceManager.getInstance().setIntValue(BADGE_COUNT, this.mBrandId, counter);
        PreferenceManager.getInstance().setIntValue(BADGE_SEQUENCE, this.mBrandId, sequence);
    }

    private void returnCachedDetails() {
        LPMobileLog.d((String)TAG, (String)"Return cached badge counter");
        String conversationId = PreferenceManager.getInstance().getStringValue(BADGE_CONVERSATION_ID, this.mBrandId, "");
        int sequence = PreferenceManager.getInstance().getIntValue(BADGE_SEQUENCE, this.mBrandId, 0);
        int counter = PreferenceManager.getInstance().getIntValue(BADGE_COUNT, this.mBrandId, 0);
        this.validateCounterWithSequence(conversationId, sequence, counter);
    }

    private boolean isBadgeThresholdWasPassed(String brandId) {
        long lastTimestamp = PreferenceManager.getInstance().getLongValue(BADGE_TIMESTAMP, brandId, 0L);
        long delta = System.currentTimeMillis() - lastTimestamp;
        return lastTimestamp == 0L || delta > 10000L;
    }
}

