/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.SiteSettingsRequest;
import com.liveperson.infra.utils.VersionUtils;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SiteSettingsFetcherTask
extends BaseAmsAccountConnectionTask {
    public static final String TAG = "SiteSettingsFetcherTask";
    public static final String SITE_SETTINGS_PROPERTY_NAME_ID = "id";
    public static final String SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE = "propertyValue";
    public static final String SITE_SETTINGS_PROPERTY_NAME_VALUE = "value";
    public static final String SITE_SETTINGS_PHOTO_SHARING_ID_VALUE = "messaging.file.sharing.enabled";
    public static final String SITE_SETTINGS_AUDIO_SHARING_ID_VALUE = "messaging.audio.sharing.enabled";
    public static final String SITE_SETTINGS_MIN_VERSION_ID_VALUE = "messaging.android.sdk.min.version";
    private final AccountsController mAccountsController;
    private boolean mPhotoSharingEnabled = true;
    private boolean mVoiceSharingEnabled = true;
    private String mMinSdkVersionFromServer;

    public SiteSettingsFetcherTask(AccountsController accountsController) {
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPMobileLog.d((String)TAG, (String)"Running site settings check task...");
        AmsConnectionAnalytics.siteSettingsFetcherTaskStart();
        String siteSettingsServiceDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "acCdnDomain");
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        new SiteSettingsRequest(siteSettingsServiceDomain, this.mBrandId, certificates, (ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String siteSettingsJsonString) {
                if (!TextUtils.isEmpty((CharSequence)siteSettingsJsonString)) {
                    SiteSettingsFetcherTask.this.mMinSdkVersionFromServer = null;
                    boolean success = SiteSettingsFetcherTask.this.parseConfigurationData(siteSettingsJsonString);
                    if (success) {
                        LPMobileLog.d((String)SiteSettingsFetcherTask.TAG, (String)("onSuccess: Got photo sharing enable value from site settings: " + SiteSettingsFetcherTask.this.mPhotoSharingEnabled));
                    } else {
                        LPMobileLog.w((String)SiteSettingsFetcherTask.TAG, (String)"onSuccess: Cannot get photo sharing enable value from site settings. Use default (true)");
                    }
                    if (SiteSettingsFetcherTask.this.mMinSdkVersionFromServer != null) {
                        LPMobileLog.d((String)SiteSettingsFetcherTask.TAG, (String)"onSuccess: Checking SDK version against version from site-settings");
                        SiteSettingsFetcherTask.this.mAccountsController.getConnectionParamsCache(SiteSettingsFetcherTask.this.mBrandId).updateAcCdnVersion(SiteSettingsFetcherTask.this.mMinSdkVersionFromServer);
                        if (!VersionUtils.isValidSdkVersion((String)SiteSettingsFetcherTask.this.mMinSdkVersionFromServer)) {
                            String detailMessage = "Current SDK version is smaller than the one from the server (" + SiteSettingsFetcherTask.this.mMinSdkVersionFromServer + "). SDK will not connect. Please upgrade SDK. ";
                            SiteSettingsFetcherTask.this.mCallback.onTaskError(TaskType.VERSION, new Exception(detailMessage));
                            return;
                        }
                    } else {
                        LPMobileLog.w((String)SiteSettingsFetcherTask.TAG, (String)"onSuccess: did not get min SDK version from site-settings. Ignore and continue as usual");
                    }
                    AmsConnectionAnalytics.siteSettingsFetcherTaskEnd();
                    SiteSettingsFetcherTask.this.mCallback.onTaskSuccess();
                }
            }

            public void onError(Exception exception) {
                if (exception instanceof SSLPeerUnverifiedException) {
                    SiteSettingsFetcherTask.this.mCallback.onTaskError(TaskType.INVALID_CERTIFICATE, exception);
                } else {
                    SiteSettingsFetcherTask.this.mCallback.onTaskSuccess();
                }
            }
        }).execute();
    }

    private boolean parseConfigurationData(String siteSettingsJsonString) {
        try {
            this.mPhotoSharingEnabled = true;
            JSONArray jsonarray = new JSONArray(siteSettingsJsonString);
            for (int i = 0; i < jsonarray.length(); ++i) {
                JSONObject propertyValue;
                JSONObject jsonobject = jsonarray.getJSONObject(i);
                String id = jsonobject.getString(SITE_SETTINGS_PROPERTY_NAME_ID);
                if (id.equalsIgnoreCase(SITE_SETTINGS_PHOTO_SHARING_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    String enabled = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    if (!enabled.equalsIgnoreCase("false")) continue;
                    this.mPhotoSharingEnabled = false;
                    LPMobileLog.d((String)TAG, (String)"parseConfigurationData: photo sharing is disabled in SiteSettings");
                    continue;
                }
                if (id.equalsIgnoreCase(SITE_SETTINGS_AUDIO_SHARING_ID_VALUE)) {
                    propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                    String audioEnabled = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                    if (!audioEnabled.equalsIgnoreCase("false")) continue;
                    this.mVoiceSharingEnabled = false;
                    LPMobileLog.d((String)TAG, (String)"parseConfigurationData: audio sharing is disabled in SiteSettings");
                    continue;
                }
                if (!id.equalsIgnoreCase(SITE_SETTINGS_MIN_VERSION_ID_VALUE)) continue;
                propertyValue = jsonobject.getJSONObject(SITE_SETTINGS_PROPERTY_NAME_PROPERTY_VALUE);
                this.mMinSdkVersionFromServer = propertyValue.getString(SITE_SETTINGS_PROPERTY_NAME_VALUE);
                LPMobileLog.d((String)TAG, (String)("onSuccess: minSdkVersion from site-settings: " + this.mMinSdkVersionFromServer));
            }
            LPMobileLog.d((String)TAG, (String)("onSuccess: site settings enablePhotoSharing is: " + this.mPhotoSharingEnabled));
        }
        catch (JSONException e) {
            LPMobileLog.w((String)TAG, (String)"parseConfigurationData: error fetching photo sharing enabled from site settings. Use default (true)");
            return false;
        }
        PreferenceManager.getInstance().setBooleanValue("site_settings_photo_sharing_enabled_preference_key", "appLevelPreferences", this.mPhotoSharingEnabled);
        PreferenceManager.getInstance().setBooleanValue("site_settings_voice_sharing_enabled_preference_key", "appLevelPreferences", this.mVoiceSharingEnabled);
        return true;
    }

    @Override
    public String getName() {
        return TAG;
    }
}

