/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.liveperson.api.request.message.BasePublishMessage;
import com.liveperson.api.request.message.FilePublishMessage;
import com.liveperson.api.request.message.FormPublishMessage;
import com.liveperson.api.request.message.FormSubmissionPublishMessage;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.Participants;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.Infra;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.controller.DBEncryptionKeyHelper;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.database.tables.MessagesTable;
import com.liveperson.infra.database.transaction_helper.InsertOrUpdateSQLCommand;
import com.liveperson.infra.database.transaction_helper.InsertSQLCommand;
import com.liveperson.infra.database.transaction_helper.SQLiteCommand;
import com.liveperson.infra.database.transaction_helper.UpdateSQLCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.commands.DeliveryStatusUpdateCommand;
import com.liveperson.messaging.model.AmsMessagesLoaderProvider;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.FormsManager;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingSearchedMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.NullMessagesListener;
import com.liveperson.messaging.model.QuickRepliesMessageHolder;
import com.liveperson.messaging.network.MessageTimeoutQueue;
import com.liveperson.messaging.network.http.MessageTimeoutListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AmsMessages
extends BaseDBRepository
implements ShutDown,
Clearable,
AmsMessagesLoaderProvider {
    private static final String TAG = AmsMessages.class.getSimpleName();
    private static final int MAX_SQL_VARIABLES = 997;
    public static final int PENDING_MSG_SEQUENCE_NUMBER = -1;
    public static final int RESOLVE_MSG_SEQUENCE_NUMBER = -2;
    public static final int MASKED_CC_MSG_SEQUENCE_NUMBER = -3;
    public static final int WELCOME_MSG_SEQUENCE_NUMBER = -4;
    public static final String STRUCTURED_CONTENT_PREFIX = "lpsc:";
    private final Messaging mController;
    public final FormsManager mFormsManager;
    private MessagesListener mMessagesListener = null;
    private MessagesListener mNullMessagesListener = new NullMessagesListener();
    private QuickRepliesMessageHolder mQuickRepliesMessageHolder = null;
    public final MessageTimeoutQueue mMessageTimeoutQueue;

    public AmsMessages(Messaging controller) {
        super("messages");
        this.mController = controller;
        MessageTimeoutListener mMessageTimeoutListener = new MessageTimeoutListener(){

            @Override
            public void onMessageTimeout(String brandId) {
                AmsMessages.this.mController.onMessageTimeout(brandId);
                LPMobileLog.e((String)TAG, (String)"on message timeout received");
            }

            @Override
            public void onPublishMessageTimeout(String brandId, String eventId, String dialogId) {
                AmsMessages.this.updateMessageState(eventId, brandId, dialogId, MessagingChatMessage.MessageState.ERROR);
                LPMobileLog.e((String)TAG, (String)"on update message timeout");
            }
        };
        this.mMessageTimeoutQueue = new MessageTimeoutQueue(mMessageTimeoutListener);
        this.mFormsManager = new FormsManager();
    }

    public Cursor getMessages() {
        return null;
    }

    static Uri getContentURI(String uri) {
        return Uri.parse((String)("content://" + uri));
    }

    public DataBaseCommand<Void> updateOnCommand(String targetId, String conversationID) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                return null;
            }
        });
    }

    Cursor messagesByTarget(String brandID, int limitSize, long olderThanTimestamp, long newerThanTimestamp) {
        ConversationViewParams conversationViewParams;
        StringBuilder sql = this.getMessagesForTargetQuery().append(" WHERE ").append("dialogs").append(".").append("brand_id").append(" = \"").append(brandID).append("\"");
        if (olderThanTimestamp > -1L) {
            sql.append(" AND ").append("timeStamp").append(" <= ").append(olderThanTimestamp);
        }
        if (newerThanTimestamp > -1L) {
            sql.append(" AND ").append("timeStamp").append(" >= ").append(newerThanTimestamp);
        }
        if ((conversationViewParams = this.mController.getConversationViewParams()).getHistoryConversationsMaxDays() > -1) {
            long historyConversationsMaxDays = (long)conversationViewParams.getHistoryConversationsMaxDays() * 86400000L;
            long daysAgo = System.currentTimeMillis() - historyConversationsMaxDays;
            switch (conversationViewParams.getHistoryConversationMaxDaysType()) {
                case endConversationDate: {
                    sql.append(" AND ").append("dialogs").append(".").append("end_timestamp").append(" >= ").append(daysAgo);
                    break;
                }
                case startConversationDate: {
                    sql.append(" AND ").append("dialogs").append(".").append("start_timestamp").append(" >= ").append(daysAgo);
                }
            }
        }
        switch (conversationViewParams.getHistoryConversationsStateToDisplay()) {
            case OPEN: {
                sql.append(" AND ").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.OPEN.ordinal());
                break;
            }
            case CLOSE: {
                sql.append(" AND ").append("dialogs").append(".").append("state").append(" = ").append(ConversationState.CLOSE.ordinal());
                break;
            }
        }
        if (limitSize > 0) {
            sql.append(" ORDER BY ").append("timeStamp").append(" DESC ");
            sql.append(" LIMIT ").append(limitSize);
            sql = new StringBuilder("Select * FROM ( ").append((CharSequence)sql).append(" ) ORDER BY ").append("timeStamp").append(" ASC ");
        } else {
            sql.append(" ORDER BY ").append("timeStamp").append(" ASC ");
        }
        return this.getDB().rawQuery(sql.toString(), new Object[0]);
    }

    Cursor messagesByConversationID(String conversationID, int limitSize) {
        StringBuilder sql = this.getBasicMessagesQuery().append(" WHERE ").append("dialogs").append(".").append("dialog_id").append(" = \"").append(conversationID).append("\"").append(" ORDER BY ").append("timeStamp");
        if (limitSize != -1) {
            sql.append(" LIMIT ").append(limitSize);
        }
        return this.getDB().rawQuery(sql.toString(), new Object[0]);
    }

    private StringBuilder getMessagesForTargetQuery() {
        return new StringBuilder().append("select ").append("messages").append(".").append("_id").append(",").append("messages").append(".").append("eventId").append(",").append("messages").append(".").append("originatorId").append(",").append("messages").append(".").append("encryptVer").append(" AS ").append("message_encryptVer").append(",").append("users").append(".").append("encryptVer").append(" AS ").append("user_encryptVer").append(",").append("serverSequence").append(",").append("dialogId").append(",").append("text").append(",").append("contentType").append(",").append("type").append(",").append("status").append(",").append("timeStamp").append(",").append("profileImage").append(",").append("nickname").append(",").append("files").append(".").append("_id").append(" AS ").append("file_row_id").append(",").append("fileType").append(",").append("localUrl").append(",").append("preview").append(",").append("loadStatus").append(",").append("relatedMessageRowID").append(",").append("swiftPath").append(" from ").append("messages").append(" left join ").append("dialogs").append(" on ").append("messages").append(".").append("dialogId").append("=").append("dialogs").append(".").append("dialog_id").append(" left join ").append("users").append(" on ").append("messages").append(".").append("originatorId").append("=").append("users").append(".").append("originatorId").append(" left join ").append("files").append(" on ").append("messages").append(".").append("_id").append("=").append("files").append(".").append("relatedMessageRowID");
    }

    @NonNull
    private StringBuilder getBasicMessagesQuery() {
        return new StringBuilder().append("select ").append("messages").append("._id, serverSequence,convID,text,contentType,type,status,").append("messages").append(".eventId,").append("messages").append(".originatorId,timeStamp,encryptVer,").append("description,firstName,lastName,phoneNumber,userType,email,profileImage,coverImage from ").append("messages").append(" left join ").append("dialogs").append(" on ").append("messages").append(".").append("dialogId").append("=").append("dialogs").append(".").append("dialog_id").append(" left join ").append("users").append(" on ").append("messages").append(".").append("originatorId").append("=").append("users").append(".").append("originatorId");
    }

    public DataBaseCommand<Long> addMessage(String targetId, final MessagingChatMessage message, final boolean updateUI) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Long>(){

            public Long query() {
                long rowId;
                boolean isEmptyEventId = TextUtils.isEmpty((CharSequence)message.getEventId());
                if (isEmptyEventId) {
                    LPMobileLog.i((String)TAG, (String)"Received new message without event id, generating new one.. ");
                    message.setEventId(UniqueID.createUniqueMessageEventId());
                    StringBuilder whereBuilder = new StringBuilder();
                    whereBuilder.append("dialogId").append(" = ? AND ").append("serverSequence").append(" = ?");
                    rowId = AmsMessages.this.getDB().insertOrUpdate(AmsMessages.this.getContentValuesForMessage(message), AmsMessages.this.getContentValuesForMessageUpdate(message), whereBuilder.toString(), new String[]{message.getDialogId(), String.valueOf(message.getServerSequence())});
                    LPMobileLog.d((String)TAG, (String)("Insert or Update message: " + (Object)((Object)message) + " rowId = " + rowId));
                } else {
                    Cursor cursor = null;
                    cursor = AmsMessages.this.getDB().query(AmsMessages.this.getProjection(), "eventId = ?", new String[]{message.getEventId()}, null, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        ContentValues messageValues = AmsMessages.this.getContentValuesForMessageUpdate(message, cursor);
                        if (messageValues.size() > 0) {
                            rowId = AmsMessages.this.getDB().update(messageValues, "eventId=?", new String[]{String.valueOf(message.getEventId())});
                            LPMobileLog.d((String)TAG, (String)("Adding message: This message was update with message: " + (Object)((Object)message) + " rowId = " + rowId));
                        } else {
                            rowId = -1L;
                            LPMobileLog.d((String)TAG, (String)("Adding message: Skip add\\update this message since its already exist" + (Object)((Object)message) + " rowId = " + rowId));
                        }
                    } else {
                        rowId = AmsMessages.this.getDB().insertWithOnConflict(AmsMessages.this.getContentValuesForMessage(message));
                        LPMobileLog.d((String)TAG, (String)("Adding message: " + (Object)((Object)message) + " rowId = " + rowId));
                    }
                }
                if (updateUI) {
                    if (rowId != -1L) {
                        AmsMessages.this.getMessagesListener().onNewMessage(AmsMessages.this.createFullMessageRow(rowId, message, -1L));
                    } else {
                        String eventIdToUpdate = message.getEventId();
                        if (isEmptyEventId) {
                            LPMobileLog.d((String)TAG, (String)"Updating message that originally didn't have event id. ");
                            eventIdToUpdate = AmsMessages.this.getEventIdForMessage(message.getDialogId(), message.getServerSequence());
                        }
                        if (!TextUtils.isEmpty((CharSequence)eventIdToUpdate)) {
                            AmsMessages.this.updateMessageByEventId(eventIdToUpdate);
                        }
                    }
                }
                return rowId;
            }
        });
    }

    public DataBaseCommand<Integer> updateMessageOnRetry(String targetId, final MessagingChatMessage message) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){

            public Integer query() {
                LPMobileLog.d((String)TAG, (String)("Updating message: " + (Object)((Object)message)));
                int numOfRowsAffected = AmsMessages.this.getDB().update(AmsMessages.this.getContentValuesForMessage(message), "eventId=? and serverSequence =?", new String[]{String.valueOf(message.getEventId()), String.valueOf(-1)});
                return numOfRowsAffected;
            }
        });
    }

    public DataBaseCommand<Void> addMultipleMessages(final ArrayList<ContentEventNotification> responseMessages, final String originatorId, final String brandId, final String targetId, final String dialogId, final String conversationId, final long clockDiff, final boolean firstNotification, final boolean mShouldUpdateUI) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public String[] extractLinks(String text) {
                ArrayList<String> links = new ArrayList<String>();
                String[] l = text.split("\\s+");
                for (int i = 0; i < l.length; ++i) {
                    if (!URLUtil.isValidUrl((String)l[i])) continue;
                    links.add(l[i]);
                }
                return links.toArray(new String[links.size()]);
            }

            private MessagingChatMessage.MessageType checkIfMessageContainsURLandChangeType(MessagingChatMessage.MessageType type, String msg) {
                String[] urls = this.extractLinks(msg);
                if (urls.length > 0) {
                    if (type == MessagingChatMessage.MessageType.CONSUMER) {
                        return MessagingChatMessage.MessageType.CONSUMER_URL;
                    }
                    if (type == MessagingChatMessage.MessageType.CONSUMER_MASKED) {
                        return MessagingChatMessage.MessageType.CONSUMER_URL_MASKED;
                    }
                    if (type == MessagingChatMessage.MessageType.AGENT) {
                        return MessagingChatMessage.MessageType.AGENT_URL;
                    }
                }
                return type;
            }

            public Void query() {
                if (responseMessages != null) {
                    LPMobileLog.d((String)TAG, (String)("Start addMultipleMessages. num of commands = " + responseMessages.size()));
                    ArrayList<SQLiteCommand> commands = new ArrayList<SQLiteCommand>(responseMessages.size());
                    MessagingChatMessage message = null;
                    int firstSequence = -1;
                    int lastSequence = -1;
                    int maxAcceptStatusSequence = -1;
                    int maxReadStatusSequence = -1;
                    int lastAgentMessageSequence = -1;
                    for (ContentEventNotification notification : responseMessages) {
                        if (notification.event == null) {
                            LPMobileLog.e((String)TAG, (String)"received message with empty event! continuing to next message.. ");
                            continue;
                        }
                        switch (notification.event.type) {
                            case ContentEvent: {
                                MessagingChatMessage.MessageState messageState;
                                MessagingChatMessage.MessageType messageType;
                                BasePublishMessage publishMessage = null;
                                if (notification.event.message != null) {
                                    publishMessage = notification.event.message;
                                }
                                if (publishMessage == null || publishMessage.getType() == BasePublishMessage.PublishMessageType.TEXT && TextUtils.isEmpty((CharSequence)publishMessage.getMessageText())) {
                                    LPMobileLog.e((String)TAG, (String)("Text message received in query messages is empty :| shouldn't happen! dialogId = " + dialogId + " , sequence = " + notification.sequence));
                                    break;
                                }
                                ContentType contentType = ContentType.fromString(notification.event.contentType);
                                if (TextUtils.equals((CharSequence)originatorId, (CharSequence)notification.originatorId)) {
                                    messageType = MessagingChatMessage.MessageType.getMessageContentTypeForConsumer(notification, contentType);
                                    messageState = MessagingChatMessage.MessageState.SENT;
                                } else {
                                    if (notification.originatorMetadata != null && notification.originatorMetadata.mRole == Participants.ParticipantRole.CONTROLLER) {
                                        messageType = MessagingChatMessage.MessageType.CONTROLLER_SYSTEM;
                                    } else {
                                        messageType = MessagingChatMessage.MessageType.getMessageContentTypeForAgent(notification, contentType);
                                        ((AmsMessages)AmsMessages.this).mController.amsConversations.resetEffectiveTTR(targetId);
                                        ((AmsMessages)AmsMessages.this).mController.amsDialogs.resetEffectiveTTR(targetId);
                                        lastAgentMessageSequence = notification.sequence;
                                    }
                                    messageState = MessagingChatMessage.MessageState.RECEIVED;
                                }
                                if (messageType == MessagingChatMessage.MessageType.CONSUMER || messageType == MessagingChatMessage.MessageType.CONSUMER_MASKED || messageType == MessagingChatMessage.MessageType.AGENT) {
                                    messageType = this.checkIfMessageContainsURLandChangeType(messageType, publishMessage.getMessageText());
                                }
                                message = this.createMessageInDB(commands, messageState, messageType, notification, publishMessage, contentType);
                                AmsMessages.this.getQuickRepliesFromEvent(brandId, notification, messageType, dialogId);
                                if (firstSequence == -1) {
                                    firstSequence = notification.sequence;
                                }
                                lastSequence = notification.sequence;
                                break;
                            }
                            case RichContentEvent: {
                                MessagingChatMessage.MessageState messageState;
                                BasePublishMessage publishMessage = null;
                                if (notification.event.message != null) {
                                    publishMessage = notification.event.message;
                                }
                                if (publishMessage == null || publishMessage.getType() == BasePublishMessage.PublishMessageType.TEXT && TextUtils.isEmpty((CharSequence)publishMessage.getMessageText())) {
                                    LPMobileLog.e((String)TAG, (String)("Text message received in query messages is empty :| shouldn't happen! dialogId = " + dialogId + " , sequence = " + notification.sequence));
                                    break;
                                }
                                ContentType contentType = ContentType.text_structured_content;
                                MessagingChatMessage.MessageType messageType = MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT;
                                if (TextUtils.equals((CharSequence)originatorId, (CharSequence)notification.originatorId)) {
                                    messageState = MessagingChatMessage.MessageState.SENT;
                                } else {
                                    messageState = MessagingChatMessage.MessageState.RECEIVED;
                                    ((AmsMessages)AmsMessages.this).mController.amsConversations.resetEffectiveTTR(targetId);
                                    ((AmsMessages)AmsMessages.this).mController.amsDialogs.resetEffectiveTTR(targetId);
                                    lastAgentMessageSequence = notification.sequence;
                                }
                                this.createMessageInDB(commands, messageState, messageType, notification, publishMessage, contentType);
                                AmsMessages.this.getQuickRepliesFromEvent(brandId, notification, messageType, dialogId);
                                if (firstSequence == -1) {
                                    firstSequence = notification.sequence;
                                }
                                lastSequence = notification.sequence;
                                break;
                            }
                            case AcceptStatusEvent: {
                                MessagingChatMessage.MessageState messageState = AmsMessages.this.getReceivedMessageState(notification.event.status);
                                int[] sequenceList = notification.event.sequenceList;
                                if (messageState == null) {
                                    LPMobileLog.e((String)TAG, (String)("messageState is null :| shouldn't happen! original status: " + (Object)((Object)notification.event.status) + ", dialogId = " + dialogId + " , sequence = " + Arrays.toString(sequenceList)));
                                    break;
                                }
                                if (!TextUtils.equals((CharSequence)originatorId, (CharSequence)notification.originatorId) && sequenceList[0] == lastAgentMessageSequence) {
                                    LPMobileLog.d((String)TAG, (String)("AcceptStatusEvent recieved from agent for agent message. we ignore this event. lastAgentMsgSequence = " + lastAgentMessageSequence));
                                    break;
                                }
                                if (sequenceList == null || sequenceList.length <= 0) break;
                                int length = sequenceList.length;
                                int lastStatusSequence = sequenceList[length - 1];
                                if (messageState == MessagingChatMessage.MessageState.READ && maxReadStatusSequence < lastStatusSequence) {
                                    maxReadStatusSequence = lastStatusSequence;
                                } else if (messageState == MessagingChatMessage.MessageState.RECEIVED && maxAcceptStatusSequence < lastStatusSequence) {
                                    maxAcceptStatusSequence = lastStatusSequence;
                                } else {
                                    for (int i = 0; i < length; i += 996) {
                                        int[] tempArray;
                                        int size;
                                        int n = size = length - i > 996 ? 996 : length - i;
                                        if (size == length) {
                                            tempArray = sequenceList;
                                        } else {
                                            tempArray = new int[997];
                                            System.arraycopy(sequenceList, i, tempArray, 0, size);
                                        }
                                        ContentValues contentValues = new ContentValues();
                                        StringBuilder whereBuilder = new StringBuilder();
                                        String[] whereArgs = new String[size + 2];
                                        AmsMessages.this.createStatementForUpdateMessagesState(dialogId, tempArray, messageState, size, contentValues, whereBuilder, whereArgs);
                                        commands.add((SQLiteCommand)new UpdateSQLCommand(contentValues, whereBuilder.toString(), whereArgs));
                                    }
                                }
                                if (firstSequence == -1) {
                                    firstSequence = sequenceList[0];
                                }
                                if (lastSequence >= lastStatusSequence) break;
                                lastSequence = lastStatusSequence;
                            }
                        }
                    }
                    LPMobileLog.d((String)TAG, (String)("dialogId = " + dialogId + ", responseMessages.size()  = " + responseMessages.size()));
                    if (AmsMessages.this.mQuickRepliesMessageHolder != null && !MessagingFactory.getInstance().getController().isDialogClosed(dialogId)) {
                        LPMobileLog.d((String)TAG, (String)"QuickReplies exist in the received message, write to SharedPrefs");
                        AmsMessages.this.mQuickRepliesMessageHolder.writeToSharedPreferences();
                    }
                    if (maxReadStatusSequence > -1) {
                        LPMobileLog.d((String)TAG, (String)("dialogId = " + dialogId + ", maxReadStatusSequence = " + maxReadStatusSequence));
                        commands.add((SQLiteCommand)AmsMessages.this.createStatementForUpdateMaxMessagesState(dialogId, MessagingChatMessage.MessageState.READ, maxReadStatusSequence));
                    }
                    if (maxAcceptStatusSequence > -1 && maxAcceptStatusSequence > maxReadStatusSequence) {
                        LPMobileLog.d((String)TAG, (String)("dialogId = " + dialogId + ", maxAcceptStatusSequence = " + maxAcceptStatusSequence));
                        commands.add((SQLiteCommand)AmsMessages.this.createStatementForUpdateMaxMessagesState(dialogId, MessagingChatMessage.MessageState.RECEIVED, maxAcceptStatusSequence));
                    }
                    AmsMessages.this.getDB().runTransaction(commands);
                    if (mShouldUpdateUI) {
                        AmsMessages.this.updateMessages(firstNotification, dialogId, firstSequence, lastSequence);
                    }
                    AmsMessages.this.sendReadAckOnMessages(brandId, targetId, originatorId);
                }
                return null;
            }

            @NonNull
            private MessagingChatMessage createMessageInDB(ArrayList<SQLiteCommand> commands, MessagingChatMessage.MessageState messageState, MessagingChatMessage.MessageType messageType, ContentEventNotification notification, BasePublishMessage publishMessage, ContentType contentType) {
                MessagingChatMessage message;
                String eventId = notification.eventId;
                if (TextUtils.isEmpty((CharSequence)eventId)) {
                    eventId = UniqueID.createUniqueMessageEventId();
                    LPMobileLog.d((String)TAG, (String)("no event id for message: " + publishMessage.getMessageText() + " creating event id: " + eventId));
                    StringBuilder whereBuilder = new StringBuilder();
                    whereBuilder.append("dialogId").append(" = ? AND ").append("serverSequence").append(" = ?");
                    message = this.createMessage(publishMessage.getMessageText(), messageState, messageType, notification, eventId, contentType.getText());
                    InsertOrUpdateSQLCommand insertOrUpdateSQLCommand = new InsertOrUpdateSQLCommand(AmsMessages.this.getContentValuesForMessage(message), AmsMessages.this.getContentValuesForMessageUpdate(message), whereBuilder.toString(), new String[]{dialogId, String.valueOf(notification.sequence)});
                    this.AddSqliteCommandListenerForFile(publishMessage, (SQLiteCommand)insertOrUpdateSQLCommand);
                    this.AddCommandForForm(publishMessage, message, brandId, commands);
                    commands.add((SQLiteCommand)insertOrUpdateSQLCommand);
                } else {
                    message = this.createMessage(publishMessage.getMessageText(), messageState, messageType, notification, eventId, contentType.getText());
                    Cursor cursor = null;
                    cursor = AmsMessages.this.getDB().query(AmsMessages.this.getProjection(), "eventId = ?", new String[]{message.getEventId()}, null, null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        ContentValues messageValues = AmsMessages.this.getContentValuesForMessageUpdate(message, cursor);
                        if (messageValues.size() > 0) {
                            LPMobileLog.d((String)TAG, (String)("Updating message: This message need to be update with message: " + (Object)((Object)message)));
                            UpdateSQLCommand updateSQLCommand = new UpdateSQLCommand(messageValues, "eventId=?", new String[]{String.valueOf(message.getEventId())});
                            this.AddSqliteCommandListenerForFile(publishMessage, (SQLiteCommand)updateSQLCommand);
                            this.AddCommandForForm(publishMessage, message, brandId, commands);
                            commands.add((SQLiteCommand)updateSQLCommand);
                        } else {
                            LPMobileLog.d((String)TAG, (String)("Updating message: Skip updating this message since its already exist" + (Object)((Object)message)));
                        }
                    } else {
                        InsertSQLCommand insertSQLCommand = new InsertSQLCommand(AmsMessages.this.getContentValuesForMessage(message));
                        this.AddSqliteCommandListenerForFile(publishMessage, (SQLiteCommand)insertSQLCommand);
                        this.AddCommandForForm(publishMessage, message, targetId, commands);
                        commands.add((SQLiteCommand)insertSQLCommand);
                    }
                }
                return message;
            }

            @NonNull
            private MessagingChatMessage createMessage(String textMessage, MessagingChatMessage.MessageState messageState, MessagingChatMessage.MessageType messageType, ContentEventNotification notification, String eventId, String contentType) {
                MessagingChatMessage message = new MessagingChatMessage(notification.originatorId, textMessage, notification.serverTimestamp + clockDiff, dialogId, eventId, messageType, messageState, notification.sequence, contentType, EncryptionVersion.NONE);
                LPMobileLog.d((String)TAG, (String)("creating message '" + textMessage + "', seq: " + notification.sequence + ", at time: " + notification.serverTimestamp + ", dialogId: " + dialogId + ", clock diff: " + clockDiff + " = " + (notification.serverTimestamp + clockDiff)));
                return message;
            }

            private void AddCommandForForm(BasePublishMessage publishMessage, MessagingChatMessage msg, String brandId2, ArrayList<SQLiteCommand> commands) {
                Form form;
                BasePublishMessage formPublishMessage;
                if (publishMessage.getType() == BasePublishMessage.PublishMessageType.FORM_INVITATION) {
                    formPublishMessage = (FormPublishMessage)publishMessage;
                    LPMobileLog.d((String)TAG, (String)("onResult: new form obj to DB getMessage " + ((FormPublishMessage)formPublishMessage).getMessage()));
                    ((AmsMessages)AmsMessages.this).mController.amsMessages.mFormsManager.addForm(((FormPublishMessage)formPublishMessage).getInvitationId(), new Form(msg.getDialogId(), conversationId, ((FormPublishMessage)formPublishMessage).getInvitationId(), ((FormPublishMessage)formPublishMessage).getFormId(), ((FormPublishMessage)formPublishMessage).getFormTitle(), ((AmsMessages)AmsMessages.this).mController.mAccountsController.getTokenizerUrl(brandId2), brandId2, msg.getServerSequence(), msg.getEventId()));
                }
                if (publishMessage.getType() == BasePublishMessage.PublishMessageType.FORM_SUBMISSION && (form = ((AmsMessages)AmsMessages.this).mController.amsMessages.mFormsManager.getForm(((FormSubmissionPublishMessage)(formPublishMessage = (FormSubmissionPublishMessage)publishMessage)).getInvitationId())) != null) {
                    ((AmsMessages)AmsMessages.this).mController.amsMessages.mFormsManager.updateForm(((FormSubmissionPublishMessage)formPublishMessage).getInvitationId(), ((FormSubmissionPublishMessage)formPublishMessage).getmSubmissionId());
                    LPMobileLog.d((String)TAG, (String)"Updating message: This message need to be update with message: ");
                    ContentValues cv = new ContentValues();
                    cv.put("status", Integer.valueOf(AmsMessages.this.getReceivedMessageState(DeliveryStatus.SUBMITTED).ordinal()));
                    UpdateSQLCommand updateSQLCommand = new UpdateSQLCommand(cv, "eventId=?", new String[]{String.valueOf(form.getEventId())});
                    commands.add((SQLiteCommand)updateSQLCommand);
                }
            }

            private void AddSqliteCommandListenerForFile(BasePublishMessage publishMessage, SQLiteCommand sqLiteCommand) {
                if (publishMessage.getType() == BasePublishMessage.PublishMessageType.FILE) {
                    final BasePublishMessage finalPublishMessage = publishMessage;
                    sqLiteCommand.setListener(new SQLiteCommand.SQLiteCommandListener(){

                        public void onInsertComplete(long rowId) {
                            String tag = "onInsertComplete";
                            if (rowId == -1L) {
                                LPMobileLog.d((String)TAG, (String)(tag + ": message was updated on DB (and not inserted). No need to add the file to DB"));
                            } else {
                                AmsMessages.this.addFileFromPublishMessageToDB(rowId, tag, (FilePublishMessage)finalPublishMessage, targetId);
                            }
                        }
                    });
                }
            }
        });
    }

    private void getQuickRepliesFromEvent(String brandId, ContentEventNotification notification, MessagingChatMessage.MessageType messageType, String dialogId) {
        if (MessagingFactory.getInstance().getController().isDialogClosed(dialogId)) {
            LPMobileLog.d((String)TAG, (String)"getQuickRepliesFromEvent: conversation is closed, not adding QuickReplies message");
            return;
        }
        if (messageType == MessagingChatMessage.MessageType.AGENT || messageType == MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT || messageType == MessagingChatMessage.MessageType.AGENT_URL) {
            QuickRepliesMessageHolder currentQuickRepliesMessageHolder = QuickRepliesMessageHolder.fromContentEventNotification(brandId, notification);
            LPMobileLog.d((String)TAG, (String)"getQuickRepliesFromEvent: Message is from agent, try to get QuickReplies string from event");
            if (this.mQuickRepliesMessageHolder == null || currentQuickRepliesMessageHolder != null && currentQuickRepliesMessageHolder.newerThan(this.mQuickRepliesMessageHolder)) {
                LPMobileLog.d((String)TAG, (String)"QuickReplies", (String)("QuickReplies message is newer than the current one. New one: " + (currentQuickRepliesMessageHolder != null ? currentQuickRepliesMessageHolder.toString() : "null")));
                this.mQuickRepliesMessageHolder = currentQuickRepliesMessageHolder;
            }
        }
    }

    @Override
    public QuickRepliesMessageHolder getQuickRepliesMessageHolder(String brandId) {
        if (this.mQuickRepliesMessageHolder == null) {
            this.mQuickRepliesMessageHolder = QuickRepliesMessageHolder.loadFromSharedPreferences(brandId);
        }
        return this.mQuickRepliesMessageHolder;
    }

    @Override
    public void resetQuickRepliesMessageHolder() {
        LPMobileLog.d((String)TAG, (String)"resetQuickRepliesMessageHolder: resetting QuickRepliesMessageHolder");
        this.mQuickRepliesMessageHolder = null;
    }

    @NonNull
    private ContentValues getContentValuesForMessageUpdate(MessagingChatMessage message, Cursor cursor) {
        MessagingChatMessage existingMessage = AmsMessages.getSingleMessageFromCursor(cursor);
        ContentValues messageValues = new ContentValues();
        if (message.getMessageState().ordinal() != existingMessage.getMessageState().ordinal() && MessagingChatMessage.MessageState.validChange(existingMessage.getMessageState(), message.getMessageState())) {
            messageValues.put("status", Integer.valueOf(message.getMessageState().ordinal()));
        } else {
            LPMobileLog.d((String)TAG, (String)("Skip update message state, old val: " + (Object)((Object)message.getMessageState()) + " , new val: " + (Object)((Object)existingMessage.getMessageState())));
        }
        if (message.getServerSequence() != existingMessage.getServerSequence()) {
            messageValues.put("serverSequence", Integer.valueOf(message.getServerSequence()));
        } else {
            LPMobileLog.d((String)TAG, (String)("Skip update message server sequence, old val: " + message.getServerSequence() + " , new val: " + existingMessage.getServerSequence()));
        }
        return messageValues;
    }

    public void addFileFromPublishMessageToDB(long messageRowId, String tag, FilePublishMessage finalPublishMessage, String targetId) {
        LPMobileLog.d((String)TAG, (String)(tag + ": MessagingChatMessage was added. row id: " + messageRowId + ". Adding fileMessage to db."));
        String previewImagePath = ImageUtils.saveBase64ToDisk((Context)Infra.instance.getApplicationContext(), (String)finalPublishMessage.getPreview(), (String)targetId);
        LPMobileLog.d((String)TAG, (String)(tag + ": preview image saved to location: " + previewImagePath));
        if (previewImagePath != null) {
            FileMessage fileMessage = new FileMessage(previewImagePath, finalPublishMessage.getFileType(), null, finalPublishMessage.getRelativePath(), messageRowId);
            long fileRowId = (Long)MessagingFactory.getInstance().getController().amsFiles.addFile(messageRowId, fileMessage).executeSynchronously();
            LPMobileLog.d((String)TAG, (String)(tag + ": fileMessage was added to db. fileRowId = " + fileRowId));
        }
    }

    public void updateMessageReceivedState(final String targetId, final String dialogId, final int[] sequenceList, final DeliveryStatus status) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AmsMessages.this.updateReceivedState(status, targetId, dialogId, sequenceList);
            }
        });
    }

    private void updateReceivedState(DeliveryStatus status, String targetId, String dialogId, int[] sequenceList) {
        MessagingChatMessage.MessageState messageState = this.getReceivedMessageState(status);
        if (messageState == null) {
            return;
        }
        this.updateMessagesState(targetId, dialogId, sequenceList, messageState);
    }

    @NonNull
    private MessagingChatMessage.MessageState getReceivedMessageState(DeliveryStatus status) {
        MessagingChatMessage.MessageState messageState = null;
        switch (status) {
            case ACCEPT: {
                messageState = MessagingChatMessage.MessageState.RECEIVED;
                break;
            }
            case READ: 
            case ACTION: {
                messageState = MessagingChatMessage.MessageState.READ;
                break;
            }
            case VIEWED: {
                messageState = MessagingChatMessage.MessageState.VIEWED;
                break;
            }
            case SUBMITTED: {
                messageState = MessagingChatMessage.MessageState.SUBMITTED;
                break;
            }
            case ERROR: 
            case ABORTED: {
                messageState = MessagingChatMessage.MessageState.ERROR;
            }
        }
        return messageState;
    }

    private void updateMessagesState(String targetId, String dialogId, int[] sequenceList, MessagingChatMessage.MessageState messageState) {
        if (sequenceList != null && sequenceList.length > 0) {
            ContentValues contentValues = new ContentValues();
            StringBuilder whereBuilder = new StringBuilder();
            contentValues.put("status", Integer.valueOf(messageState.ordinal()));
            this.buildQueryForUpdateStatus(whereBuilder);
            String whereClause = whereBuilder.toString();
            ArrayList<UpdateSQLCommand> commands = new ArrayList<UpdateSQLCommand>(sequenceList.length);
            for (int sequence : sequenceList) {
                String[] whereArgs = this.buildParamsForUpdateStatus(dialogId, messageState, sequence);
                commands.add(new UpdateSQLCommand(contentValues, whereClause, whereArgs));
            }
            this.getDB().runTransaction(commands);
            LPMobileLog.d((String)TAG, (String)String.format("Updated " + commands.size() + " messages on DB with state %s, sequences: %s", new Object[]{messageState, Arrays.toString(sequenceList)}));
            this.updateMessages(false, dialogId, sequenceList[0], sequenceList[sequenceList.length - 1]);
        }
    }

    private void buildQueryForUpdateStatus(StringBuilder whereBuilder) {
        whereBuilder.append("dialogId").append(" =? AND ").append("status").append(" <? AND ").append("serverSequence").append(" =?");
    }

    private void createStatementForUpdateMessagesState(String dialogId, int[] sequenceList, MessagingChatMessage.MessageState messageState, int length, ContentValues contentValues, StringBuilder whereBuilder, String[] whereArgs) {
        contentValues.put("status", Integer.valueOf(messageState.ordinal()));
        whereArgs[0] = String.valueOf(dialogId);
        whereArgs[1] = String.valueOf(messageState.ordinal());
        whereBuilder.append("dialogId").append(" =? AND ").append("status").append(" <?  AND ").append("serverSequence").append(" in (");
        for (int i = 0; i < length; ++i) {
            whereArgs[i + 2] = String.valueOf(sequenceList[i]);
            whereBuilder.append("?");
            if (i == length - 1) continue;
            whereBuilder.append(",");
        }
        whereBuilder.append(")");
    }

    private UpdateSQLCommand createStatementForUpdateMaxMessagesState(String dialogId, MessagingChatMessage.MessageState messageState, int maxSequence) {
        ContentValues contentValues = new ContentValues();
        StringBuilder whereBuilder = new StringBuilder();
        contentValues.put("status", Integer.valueOf(messageState.ordinal()));
        String[] whereArgs = new String[]{String.valueOf(dialogId), String.valueOf(messageState.ordinal()), String.valueOf(maxSequence), String.valueOf(-1)};
        whereBuilder.append("dialogId").append(" =? AND ").append("status").append(" <? AND ").append("serverSequence").append(" <=? AND ").append("serverSequence").append(" >? ");
        return new UpdateSQLCommand(contentValues, whereBuilder.toString(), whereArgs);
    }

    @NonNull
    private String[] buildParamsForUpdateStatus(String dialogId, MessagingChatMessage.MessageState messageState, int maxSequence) {
        return new String[]{String.valueOf(dialogId), String.valueOf(messageState.ordinal()), String.valueOf(maxSequence)};
    }

    public void updateAllMessagesStateByDialogId(String targetId, final String dialogId, final MessagingChatMessage.MessageState messageState) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentValues contentValues = new ContentValues();
                contentValues.put("status", Integer.valueOf(messageState.ordinal()));
                int result = AmsMessages.this.getDB().update(contentValues, "dialogId = ? ", new String[]{dialogId});
                LPMobileLog.d((String)TAG, (String)String.format("Updated %d messages on DB with state %s", new Object[]{result, messageState}));
                AmsMessages.this.updateAllMessagesForDialog(dialogId);
            }
        });
    }

    private void markPendingMessagesAsFailedOnCloseConv(final String brandId) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String rowIds = MessagingFactory.getInstance().getController().getInProgressUploadMessageRowIdsString();
                String[] whereArgs = AmsMessages.this.getPendingMessagesQueryParams(brandId, rowIds, String.valueOf(ConversationState.CLOSE.ordinal()));
                String where = AmsMessages.this.getPendingMessagesQuery(rowIds);
                Cursor cursor = AmsMessages.this.getDB().query(null, where, whereArgs, null, null, null);
                if (cursor != null) {
                    try {
                        if (cursor.getCount() == 0) {
                            return;
                        }
                        if (cursor.moveToFirst()) {
                            do {
                                MessagingChatMessage message = AmsMessages.getSingleMessageFromCursor(cursor);
                                message.setMessageState(MessagingChatMessage.MessageState.ERROR);
                                long rowId = cursor.getLong(cursor.getColumnIndex("_id"));
                                AmsMessages.this.updateMessageByRowId(rowId, message);
                            } while (cursor.moveToNext());
                        }
                    }
                    finally {
                        cursor.close();
                    }
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("status", Integer.valueOf(MessagingChatMessage.MessageState.ERROR.ordinal()));
                    int result = AmsMessages.this.getDB().update(contentValues, where, whereArgs);
                    LPMobileLog.d((String)TAG, (String)String.format("Updated %d messages on DB with state %s", new Object[]{result, MessagingChatMessage.MessageState.ERROR}));
                }
            }
        });
    }

    public void resendAllPendingMessages(final String brandId) {
        final long resendMessageTimeout = Configuration.getInteger((int)R.integer.sendingMessageTimeoutInMinutes);
        this.markPendingMessagesAsFailedOnCloseConv(brandId);
        DataBaseExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String rowIds = MessagingFactory.getInstance().getController().getInProgressUploadMessageRowIdsString();
                String[] whereArgs = AmsMessages.this.getPendingMessagesQueryParams(brandId, rowIds, String.valueOf(ConversationState.OPEN.ordinal()));
                String where = AmsMessages.this.getPendingMessagesQuery(rowIds);
                Cursor cursor = AmsMessages.this.getDB().query(null, where, whereArgs, null, null, null);
                if (cursor != null) {
                    try {
                        if (cursor.getCount() == 0) {
                            return;
                        }
                        if (cursor.moveToFirst()) {
                            ArrayList<String> eventIdsToErrorUpdate = new ArrayList<String>();
                            do {
                                MessagingChatMessage message = AmsMessages.getSingleMessageFromCursor(cursor);
                                String dialogId = message.getDialogId();
                                if (resendMessageTimeout > 0L && System.currentTimeMillis() < message.getTimeStamp() + TimeUnit.MINUTES.toMillis(resendMessageTimeout)) {
                                    FileMessage fileMessage;
                                    LPMobileLog.d((String)TAG, (String)("Resend message: " + (Object)((Object)message)));
                                    long rowId = -1L;
                                    if (MessagingChatMessage.MessageType.isImage(message.getMessageType()) && (fileMessage = ((AmsMessages)AmsMessages.this).mController.amsFiles.getFileByMessageRowId(message.getLocalId())) != null) {
                                        rowId = fileMessage.getFileRowId();
                                    }
                                    AmsMessages.this.mController.resendMessage(message.getEventId(), dialogId, rowId, message.getMessageType());
                                    continue;
                                }
                                LPMobileLog.d((String)TAG, (String)("Resend timeout - Set message to FAILED state,  resendMessageTimeout:" + resendMessageTimeout + ", message: " + (Object)((Object)message)));
                                eventIdsToErrorUpdate.add(message.getEventId());
                            } while (cursor.moveToNext());
                            if (!eventIdsToErrorUpdate.isEmpty()) {
                                AmsMessages.this.updateMessagesState(eventIdsToErrorUpdate, brandId, null, MessagingChatMessage.MessageState.ERROR);
                            }
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
            }
        });
    }

    private String getPendingMessagesQuery(String rowIds) {
        StringBuilder whereBuilder = new StringBuilder().append("_id").append(" in (select m.").append("_id").append(" from ").append("messages").append(" m , ").append("dialogs").append(" c ").append("where (m.").append("status").append("=").append(MessagingChatMessage.MessageState.PENDING.ordinal()).append(" or m.").append("status").append("=").append(MessagingChatMessage.MessageState.QUEUED.ordinal()).append(") and c.").append("brand_id").append("=?").append(" and c.").append("state").append("=?").append(" and m.").append("dialogId").append("= c.").append("dialog_id");
        if (!TextUtils.isEmpty((CharSequence)rowIds)) {
            LPMobileLog.d((String)TAG, (String)("resendAllPendingMessages: There is upload images in progress, ignore these messages rowId: " + rowIds));
            whereBuilder.append(" and m.").append("_id").append(" not in (?)");
        }
        whereBuilder.append(")");
        String where = whereBuilder.toString();
        LPMobileLog.d((String)TAG, (String)("getPendingMessagesQuery: where clause: " + where));
        return where;
    }

    private String[] getPendingMessagesQueryParams(String brandId, String rowIds, String state) {
        if (!TextUtils.isEmpty((CharSequence)rowIds)) {
            return new String[]{brandId, state, rowIds};
        }
        return new String[]{brandId, state};
    }

    public void updateMessageState(final String eventId, String targetId, String dialogId, final MessagingChatMessage.MessageState messageState) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentValues contentValues = new ContentValues();
                contentValues.put("status", Integer.valueOf(messageState.ordinal()));
                int result = AmsMessages.this.getDB().update(contentValues, "eventId=?", new String[]{eventId});
                LPMobileLog.d((String)TAG, (String)String.format("Updated %d messages on DB with state %s, eventId: %s", new Object[]{result, messageState, eventId}));
                AmsMessages.this.updateMessageByEventId(eventId);
            }
        });
    }

    public void updateMessagesState(final ArrayList<String> eventIds, String targetId, String dialogId, final MessagingChatMessage.MessageState messageState) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (eventIds != null && !eventIds.isEmpty()) {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("status", Integer.valueOf(messageState.ordinal()));
                    String inOperator = " IN (?";
                    for (int i = 1; i < eventIds.size(); ++i) {
                        inOperator = inOperator + ",?";
                    }
                    inOperator = inOperator + ")";
                    String[] eventIdsArray = new String[eventIds.size()];
                    eventIdsArray = eventIds.toArray(eventIdsArray);
                    int result = AmsMessages.this.getDB().update(contentValues, "eventId" + inOperator, eventIdsArray);
                    LPMobileLog.d((String)TAG, (String)String.format("Updated %d messages on DB with state %s, eventId: %s", new Object[]{result, messageState, eventIds}));
                    for (String eventId : eventIdsArray) {
                        AmsMessages.this.updateMessageByEventId(eventId);
                    }
                } else {
                    LPMobileLog.d((String)TAG, (String)("updateMessagesState - Skip updated messages , eventIdis is empty. messageState = " + (Object)((Object)messageState)));
                }
            }
        });
    }

    public void sendReadAckOnMessages(final String brandId, final String targetId, final String originatorId) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                String conversationId;
                String queryString;
                Cursor cursor = null;
                if (!TextUtils.isEmpty((CharSequence)targetId)) {
                    LPMobileLog.d((String)TAG, (String)("Get all unread messages for target " + targetId));
                    queryString = String.format("select m.%s, c.%s, c.%s from %s m, %s c where c.%s>? and c.%s=? and m.%s =? and m.%s=c.%s and m.%s >= '0' and m.%s != ?", "serverSequence", "dialog_id", "conversation_id", "messages", "dialogs", "state", "target_id", "status", "dialogId", "dialog_id", "serverSequence", "originatorId");
                    cursor = AmsMessages.this.getDB().rawQuery(queryString, new Object[]{ConversationState.LOCKED.ordinal(), targetId, MessagingChatMessage.MessageState.RECEIVED.ordinal(), originatorId});
                } else if (!TextUtils.isEmpty((CharSequence)brandId)) {
                    LPMobileLog.d((String)TAG, (String)("Get all unread messages for brand " + brandId));
                    queryString = String.format("select m.%s, c.%s, c.%s  from %s m, %s c where c.%s=? and c.%s>? and m.%s =? and m.%s=c.%s and m.%s >= '0' and m.%s != ?", "serverSequence", "dialog_id", "conversation_id", "messages", "dialogs", "brand_id", "state", "status", "dialogId", "dialog_id", "serverSequence", "originatorId");
                    cursor = AmsMessages.this.getDB().rawQuery(queryString, new Object[]{brandId, ConversationState.LOCKED.ordinal(), MessagingChatMessage.MessageState.RECEIVED.ordinal(), originatorId});
                }
                HashMap sequenceMap = new HashMap();
                HashMap<String, String> dialogIdsAndConversationIds = new HashMap<String, String>();
                if (cursor == null) return;
                try {
                    if (cursor.moveToFirst()) {
                        do {
                            String dialogId = cursor.getString(cursor.getColumnIndex("dialog_id"));
                            conversationId = cursor.getString(cursor.getColumnIndex("conversation_id"));
                            dialogIdsAndConversationIds.put(dialogId, conversationId);
                            ArrayList<Integer> list = (ArrayList<Integer>)sequenceMap.get(dialogId);
                            if (list == null) {
                                list = new ArrayList<Integer>();
                                sequenceMap.put(dialogId, list);
                            }
                            int sequence = cursor.getInt(cursor.getColumnIndex("serverSequence"));
                            list.add(sequence);
                        } while (cursor.moveToNext());
                    }
                }
                finally {
                    cursor.close();
                }
                for (String dialogId : sequenceMap.keySet()) {
                    LPMobileLog.d((String)TAG, (String)("Send a read ack to the server for dialog id " + dialogId + " on the following sequences: " + sequenceMap.get(dialogId)));
                    conversationId = (String)dialogIdsAndConversationIds.get(dialogId);
                    new DeliveryStatusUpdateCommand(((AmsMessages)AmsMessages.this).mController.mAccountsController.getConnectionUrl(brandId), !TextUtils.isEmpty((CharSequence)targetId) ? targetId : brandId, dialogId, conversationId, (List)sequenceMap.get(dialogId)).execute();
                }
            }
        });
    }

    public void setDeliveryStatusUpdateCommand(Form form, DeliveryStatus deliveryStatus) {
        if (form == null) {
            LPMobileLog.w((String)TAG, (String)"form not found!");
            return;
        }
        new DeliveryStatusUpdateCommand(this.mController.mAccountsController.getConnectionUrl(form.getSiteId()), form.getSiteId(), form.getDialogId(), form.getConversationId(), form.getSeqId(), deliveryStatus);
    }

    private ContentValues getContentValuesForMessage(MessagingChatMessage message) {
        ContentValues messageValues = this.getContentValuesForMessageUpdate(message);
        messageValues.put("eventId", message.getEventId());
        return messageValues;
    }

    private ContentValues getContentValuesForMessageUpdate(MessagingChatMessage message) {
        ContentValues messageValues = new ContentValues();
        messageValues.put("serverSequence", Integer.valueOf(message.getServerSequence()));
        messageValues.put("dialogId", message.getDialogId());
        EncryptionVersion messageEncryptionVersion = DBEncryptionKeyHelper.getAppEncryptionVersion((Context)Infra.instance.getApplicationContext());
        messageValues.put("encryptVer", Integer.valueOf(messageEncryptionVersion.ordinal()));
        String encryptedMessage = DBEncryptionHelper.encrypt((EncryptionVersion)messageEncryptionVersion, (String)message.getMessage());
        messageValues.put("text", encryptedMessage);
        messageValues.put("contentType", message.getContentType());
        messageValues.put("type", Integer.valueOf(message.getMessageType().ordinal()));
        messageValues.put("status", Integer.valueOf(message.getMessageState().ordinal()));
        messageValues.put("timeStamp", Long.valueOf(message.getTimeStamp()));
        messageValues.put("originatorId", message.getOriginatorId());
        return messageValues;
    }

    private static MessagingChatMessage getSingleMessageFromCursor(Cursor cursor) {
        long msgId = cursor.getLong(cursor.getColumnIndex("_id"));
        MessagingChatMessage message = new MessagingChatMessage(cursor.getString(cursor.getColumnIndex("originatorId")), cursor.getString(cursor.getColumnIndex("text")), cursor.getLong(cursor.getColumnIndex("timeStamp")), cursor.getString(cursor.getColumnIndex("dialogId")), cursor.getString(cursor.getColumnIndex("eventId")), MessagingChatMessage.MessageType.values()[cursor.getInt(cursor.getColumnIndex("type"))], MessagingChatMessage.MessageState.values()[cursor.getInt(cursor.getColumnIndex("status"))], cursor.getInt(cursor.getColumnIndex("serverSequence")), cursor.getString(cursor.getColumnIndex("contentType")), EncryptionVersion.fromInt((int)cursor.getInt(cursor.getColumnIndex("encryptVer"))));
        message.setMessageId(msgId);
        return message;
    }

    public void updateOnMessageAck(String targetId, String dialogId, final String eventId, final long serverSequence) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentValues contentValuesSequence = new ContentValues();
                contentValuesSequence.put("serverSequence", Long.valueOf(serverSequence));
                String whereClauseSequence = "eventId=?";
                String[] whereArgsSequence = new String[]{String.valueOf(eventId)};
                int rowsAffected = AmsMessages.this.getDB().update(contentValuesSequence, "eventId=?", whereArgsSequence);
                LPMobileLog.d((String)TAG, (String)("Update msg server seq query. Rows affected=" + rowsAffected + " Seq=" + serverSequence));
                ContentValues contentValuesStatus = new ContentValues();
                contentValuesStatus.put("status", Integer.valueOf(MessagingChatMessage.MessageState.SENT.ordinal()));
                String whereClauseStatus = "eventId=? AND (status=? OR status=?)";
                String[] whereArgsStatus = new String[]{String.valueOf(eventId), String.valueOf(MessagingChatMessage.MessageState.PENDING.ordinal()), String.valueOf(MessagingChatMessage.MessageState.ERROR.ordinal())};
                rowsAffected = AmsMessages.this.getDB().update(contentValuesStatus, "eventId=? AND (status=? OR status=?)", whereArgsStatus);
                LPMobileLog.d((String)TAG, (String)("Update msg status to SENT. Rows affected=" + rowsAffected));
                AmsMessages.this.updateMessageByEventId(eventId);
            }
        });
    }

    public DataBaseCommand<Long> getTimeOfFirstMessage() {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long query() {
                String min_time = "MIN_TIME";
                Cursor cursor = AmsMessages.this.getDB().rawQuery("SELECT MIN( timeStamp) AS " + min_time + " FROM " + "messages", new Object[0]);
                Long oldestTimestamp = System.currentTimeMillis();
                if (cursor != null) {
                    try {
                        long minTime;
                        if (cursor.moveToFirst() && (minTime = cursor.getLong(cursor.getColumnIndex(min_time))) > 0L) {
                            oldestTimestamp = minTime;
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                LPMobileLog.d((String)TAG, (String)("getTimeOfFirstMessage , oldestTimestamp = " + oldestTimestamp));
                return oldestTimestamp;
            }
        });
    }

    public DataBaseCommand<Boolean> isFirstMessageExists() {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean query() {
                Cursor cursor = AmsMessages.this.getDB().query(new String[]{"_id"}, "serverSequence = ?", new String[]{String.valueOf(-4)}, null, null, null);
                boolean firstMessageExists = false;
                if (cursor != null) {
                    try {
                        long firstMessageId;
                        if (cursor.moveToFirst() && (firstMessageId = cursor.getLong(cursor.getColumnIndex("_id"))) != -1L) {
                            firstMessageExists = true;
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                LPMobileLog.d((String)TAG, (String)("isFirstMessageExists = " + firstMessageExists));
                return firstMessageExists;
            }
        });
    }

    public DataBaseCommand<Boolean> isLastMessageWelcomeMessage() {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Boolean>(){

            public Boolean query() {
                Cursor cursor = AmsMessages.this.getDB().query(null, null, null, null, null, null);
                cursor.moveToLast();
                if (cursor.getCount() == 0) {
                    return false;
                }
                return cursor.getInt(cursor.getColumnIndex("serverSequence")) == -4;
            }
        });
    }

    public DataBaseCommand updateLastWelcomeMessage(final MessagingChatMessage message) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                Cursor cursor = AmsMessages.this.getDB().query(null, null, null, null, null, null);
                cursor.moveToLast();
                int id = cursor.getInt(cursor.getColumnIndex("_id"));
                String whereString = "_id=?";
                String[] whereArgs = new String[]{String.valueOf(id)};
                AmsMessages.this.getDB().update(AmsMessages.this.getContentValuesForMessageUpdate(message), whereString, whereArgs);
                return null;
            }
        });
    }

    public DataBaseCommand removeLastWelcomeMessage() {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                Cursor cursor = AmsMessages.this.getDB().query(null, null, null, null, null, null);
                cursor.moveToFirst();
                int firstItemId = cursor.getInt(cursor.getColumnIndex("_id"));
                cursor.moveToLast();
                int lastItemId = cursor.getInt(cursor.getColumnIndex("_id"));
                if (firstItemId != lastItemId) {
                    String whereString = "_id=?";
                    String[] whereArgs = new String[]{String.valueOf(lastItemId)};
                    AmsMessages.this.getDB().removeAll(whereString, whereArgs);
                }
                return null;
            }
        });
    }

    public DataBaseCommand<Void> updateMessagesDialogServerID(final String tempDialogId, final String serverDialogId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                ContentValues contentValues = new ContentValues();
                contentValues.put("dialogId", serverDialogId);
                int updatedRows = AmsMessages.this.getDB().update(contentValues, "dialogId=? ", new String[]{tempDialogId});
                LPMobileLog.d((String)TAG, (String)("updateMessagesConversationServerID , updatedRows = " + updatedRows));
                AmsMessages.this.updateAllMessagesForDialog(serverDialogId);
                return null;
            }
        });
    }

    public DataBaseCommand<Void> updateMessageDialogServerIdAndTime(final long messageRowId, final String dialogId, long time) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                ContentValues contentValues = new ContentValues();
                contentValues.put("dialogId", dialogId);
                int updatedRows = AmsMessages.this.getDB().update(contentValues, "_id=? ", new String[]{String.valueOf(messageRowId)});
                LPMobileLog.d((String)TAG, (String)("updateMessageDialogServerIdAndTime , rowId to update = " + messageRowId + ", updated = " + updatedRows));
                AmsMessages.this.updateMessageByRowIdOnDbThread(messageRowId);
                return null;
            }
        });
    }

    public void updateMessageState(final long messageRowId, final MessagingChatMessage.MessageState state) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentValues contentValues = new ContentValues();
                contentValues.put("status", Integer.valueOf(state.ordinal()));
                int updatedRows = AmsMessages.this.getDB().update(contentValues, "_id=? ", new String[]{String.valueOf(messageRowId)});
                LPMobileLog.d((String)TAG, (String)("updateMessageState , rowId to update = " + messageRowId + ", updated = " + updatedRows));
                AmsMessages.this.updateMessageByRowIdOnDbThread(messageRowId);
            }
        });
    }

    public void updateMessageFileChanged(String targetId, final long messageRowId) {
        if (messageRowId < 0L) {
            LPMobileLog.w((String)TAG, (String)("updateMessageFileChanged cannot be lower than zero! " + messageRowId));
            return;
        }
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AmsMessages.this.updateMessageByRowIdOnDbThread(messageRowId);
            }
        });
    }

    private String[] getProjection() {
        return MessagesTable.getProjection();
    }

    public DataBaseCommand<List<MessagingSearchedMessage>> searchMessages(final String searchString) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<List<MessagingSearchedMessage>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<MessagingSearchedMessage> query() {
                String queryString = String.format("select c.%1$s, m.%2$s, m.%3$s, u.%4$s, max(m.%5$s) from %6$s m, %7$s c, %8$s u where (m.%2$s like '%%%9$s%%' or (u.%4$s like '%%%9$s%%' and m.%3$s=1)) and m.%3$s<> 0 and m.%10$s=c.%11$s and m.%12$s=u.%13$s group by c.%1$s;", "brand_id", "text", "type", "firstName", "timeStamp", "messages", "dialogs", "users", searchString, "dialogId", "dialog_id", "originatorId", "originatorId");
                LPMobileLog.d((String)TAG, (String)("query: " + queryString));
                Cursor cursor = AmsMessages.this.getDB().rawQuery(queryString, new Object[0]);
                ArrayList<MessagingSearchedMessage> searchedMessageList = new ArrayList<MessagingSearchedMessage>();
                if (cursor != null) {
                    try {
                        if (cursor.moveToFirst()) {
                            do {
                                MessagingSearchedMessage searchedMessage;
                                if ((searchedMessage = MessagingSearchedMessage.fromCursor(cursor)) == null) continue;
                                searchedMessageList.add(searchedMessage);
                            } while (cursor.moveToNext());
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                return searchedMessageList;
            }
        });
    }

    public DataBaseCommand<int[]> getSequencesForDialog(final String dialogId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<int[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int[] query() {
                String queryString = "SELECT " + "serverSequence" + " FROM " + "messages" + " WHERE " + "dialogId" + " = ? " + " ORDER BY " + "serverSequence" + " DESC";
                Cursor cursor = AmsMessages.this.getDB().rawQuery(queryString, (Object[])new String[]{dialogId});
                int[] searchedMessageList = null;
                if (cursor != null) {
                    try {
                        searchedMessageList = new int[cursor.getCount()];
                        if (cursor.moveToFirst()) {
                            do {
                                searchedMessageList[cursor.getPosition()] = cursor.getInt(cursor.getColumnIndex("serverSequence"));
                            } while (cursor.moveToNext());
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                return searchedMessageList;
            }
        });
    }

    private MessagesListener getMessagesListener() {
        if (this.mMessagesListener != null) {
            return this.mMessagesListener;
        }
        return this.mNullMessagesListener;
    }

    @Override
    public void addOnUpdateListener(MessagesListener messagesListener, final MessagesSortedBy messagesSortedByType, final String typeValue) {
        this.mMessagesListener = messagesListener;
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList searchedMessageList = AmsMessages.this.loadMessagesOnDbThread(messagesSortedByType, typeValue, 100, -1L, -1L);
                AmsMessages.this.getMessagesListener().initMessages(searchedMessageList);
            }
        });
    }

    @Override
    public void removeOnUpdateListener() {
        this.mMessagesListener = null;
    }

    @Override
    public boolean hasListener() {
        return this.mMessagesListener != null;
    }

    @Override
    public DataBaseCommand<ArrayList<FullMessageRow>> loadMessages(final MessagesSortedBy messagesSortedByType, final String typeValue, final int limit, final long olderThanTimestamp, final long newerThanTimestamp) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<ArrayList<FullMessageRow>>(){

            public ArrayList<FullMessageRow> query() {
                return AmsMessages.this.loadMessagesOnDbThread(messagesSortedByType, typeValue, limit, olderThanTimestamp, newerThanTimestamp);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ArrayList<FullMessageRow> loadMessagesOnDbThread(MessagesSortedBy messagesSortedByType, String typeValue, int limit, long olderThanTimestamp, long newerThanTimestamp) {
        Cursor cursor = null;
        switch (messagesSortedByType) {
            case TargetId: {
                cursor = this.messagesByTarget(typeValue, limit, olderThanTimestamp, newerThanTimestamp);
                break;
            }
            case ConversationId: {
                cursor = this.messagesByConversationID(typeValue, limit);
            }
        }
        ArrayList<FullMessageRow> searchedMessageList = null;
        if (cursor != null) {
            try {
                searchedMessageList = new ArrayList<FullMessageRow>(cursor.getCount());
                if (cursor.moveToFirst()) {
                    do {
                        searchedMessageList.add(new FullMessageRow(cursor));
                    } while (cursor.moveToNext());
                }
            }
            finally {
                cursor.close();
            }
        }
        return searchedMessageList;
    }

    @Override
    public String getMyUserId(String targetId) {
        return this.mController.getOriginatorId(targetId);
    }

    @Override
    public MessagingUserProfile loadMessagingUserProfile(String originatorId) {
        return (MessagingUserProfile)this.mController.amsUsers.getUserById(originatorId).executeSynchronously();
    }

    @NonNull
    private FullMessageRow createFullMessageRow(long messageRowId, @NonNull MessagingChatMessage message, long fileRowId) {
        MessagingUserProfile messagingUserProfile = (MessagingUserProfile)this.mController.amsUsers.getUserById(message.getOriginatorId()).executeSynchronously();
        String avatarUrl = messagingUserProfile == null ? "" : messagingUserProfile.getAvatarUrl();
        FileMessage fileMessage = fileRowId != -1L ? this.mController.amsFiles.getFileByFileRowIdOnDbThread(fileRowId) : this.mController.amsFiles.getFileByMessageRowId(messageRowId);
        return new FullMessageRow(message, avatarUrl, fileMessage);
    }

    public DataBaseCommand<Integer> clearMessagesOfClosedConversations(final String targetId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){

            public Integer query() {
                String whereString = "_id in (select m._id from messages m, dialogs d where d.target_id=? and d.state=? and d.dialog_id=m.dialogId or m.dialogId=?)";
                Object[] whereArgs = new String[]{targetId, String.valueOf(DialogState.CLOSE.ordinal()), "KEY_WELCOME_DIALOG_ID"};
                int removed = AmsMessages.this.getDB().removeAll(whereString, (String[])whereArgs);
                LPMobileLog.d((String)TAG, (String)("clearMessagesOfClosedConversations: removed: " + removed + " where: " + whereString + ", whereArgs: " + Arrays.toString(whereArgs)));
                AmsMessages.this.updateMessagesRemoved(targetId);
                return removed;
            }
        });
    }

    public DataBaseCommand<Integer> clearAllMessages(final String targetId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){

            public Integer query() {
                String whereString = "_id in (select m._id from messages m, dialogs d where d.target_id=? and d.dialog_id=m.dialogId)";
                Object[] whereArgs = new String[]{targetId};
                int removed = AmsMessages.this.getDB().removeAll(whereString, (String[])whereArgs);
                LPMobileLog.d((String)TAG, (String)("clearAllMessages: removed: " + removed + " where: " + whereString + ", whereArgs: " + Arrays.toString(whereArgs)));
                AmsMessages.this.updateMessagesRemoved(targetId);
                return removed;
            }
        });
    }

    private void updateMessages(boolean firstNotification, String dialogId, int firstSequence, int lastSequence) {
        long firstTimestamp = this.getTimestampMessage(dialogId, firstSequence);
        long lastTimestamp = this.getTimestampMessage(dialogId, lastSequence);
        if (firstNotification) {
            LPMobileLog.d((String)TAG, (String)"updateMessages first notification event. onQueryMessagesResult ");
            this.getMessagesListener().onQueryMessagesResult(firstTimestamp, lastTimestamp);
        } else {
            LPMobileLog.d((String)TAG, (String)"updateMessages NOT first notification event. onUpdateMessages ");
            this.getMessagesListener().onUpdateMessages(firstTimestamp, lastTimestamp);
        }
    }

    private void updateMessagesRemoved(String targetId) {
        this.getMessagesListener().removeAll(targetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageByEventId(String eventId) {
        Cursor cursor = this.getDB().query(null, "eventId = ?", new String[]{eventId}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    MessagingChatMessage message = AmsMessages.getSingleMessageFromCursor(cursor);
                    int rowId = cursor.getInt(cursor.getColumnIndex("_id"));
                    this.getMessagesListener().onUpdateMessage(this.createFullMessageRow(rowId, message, -1L));
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEventIdForMessage(String dialogId, int sequence) {
        String eventId = null;
        Cursor cursor = this.getDB().rawQuery("SELECT eventId FROM messages WHERE dialogId =? AND serverSequence =? ", new Object[]{dialogId, sequence});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    eventId = cursor.getString(cursor.getColumnIndex("eventId"));
                }
            }
            finally {
                cursor.close();
            }
        }
        return eventId;
    }

    public DataBaseCommand<ArrayList<MessagingChatMessage>> getMessagesByDialogId(final @Nullable String dialogId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<ArrayList<MessagingChatMessage>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ArrayList<MessagingChatMessage> query() {
                if (TextUtils.isEmpty((CharSequence)dialogId)) {
                    LPMobileLog.w((String)TAG, (String)"getMessagesByDialogId - dialogId is empty");
                    return new ArrayList<MessagingChatMessage>();
                }
                try (Cursor cursor = null;){
                    String selection = "dialogId = ? AND type != ? AND type != ?";
                    String[] args = new String[]{dialogId, String.valueOf(MessagingChatMessage.MessageType.SYSTEM_RESOLVED.ordinal()), String.valueOf(MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED.ordinal())};
                    cursor = AmsMessages.this.getDB().query(AmsMessages.this.getProjection(), selection, args, null, null, null);
                    if (cursor != null) {
                        ArrayList arrayList = AmsMessages.getMessagesFromCursor(cursor);
                        return arrayList;
                    }
                }
                return null;
            }
        });
    }

    public DataBaseCommand<MessagingChatMessage> getMessageByEventId(final String eventId) {
        if (TextUtils.isEmpty((CharSequence)eventId)) {
            LPMobileLog.w((String)TAG, (String)"getMessageByEventId - eventId is empty");
            return null;
        }
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<MessagingChatMessage>(){

            public MessagingChatMessage query() {
                try (Cursor cursor = null;){
                    cursor = AmsMessages.this.getDB().query(AmsMessages.this.getProjection(), "eventId = ?", new String[]{eventId}, null, null, null);
                    if (cursor != null) {
                        MessagingChatMessage messagingChatMessage = AmsMessages.getSingleMessageFromCursor(cursor);
                        return messagingChatMessage;
                    }
                }
                return null;
            }
        });
    }

    @NonNull
    private static ArrayList<MessagingChatMessage> getMessagesFromCursor(Cursor cursor) {
        ArrayList<MessagingChatMessage> messages = new ArrayList<MessagingChatMessage>();
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    do {
                        messages.add(AmsMessages.getSingleMessageFromCursor(cursor));
                    } while (cursor.moveToNext());
                }
            }
            catch (Exception e) {
                LPMobileLog.e((String)TAG, (Throwable)e);
            }
        }
        return messages;
    }

    public DataBaseCommand<Long> getRowIdByEventId(final String eventId) {
        if (TextUtils.isEmpty((CharSequence)eventId)) {
            LPMobileLog.w((String)TAG, (String)"getRowIdByEventId - eventId is empty");
            return null;
        }
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Long>(){

            public Long query() {
                try (Cursor cursor = null;){
                    cursor = AmsMessages.this.getDB().query(new String[]{"_id"}, "eventId = ?", new String[]{eventId}, null, null, null);
                    if (cursor != null) {
                        Long l = cursor.getLong(cursor.getColumnIndex("_id"));
                        return l;
                    }
                }
                return -1L;
            }
        });
    }

    private void updateMessageByRowIdOnDbThread(long messageRowId) {
        MessagingChatMessage message = this.getMessageByRowIdOnDbThread(messageRowId);
        if (message != null) {
            this.getMessagesListener().onUpdateMessage(this.createFullMessageRow(messageRowId, message, -1L));
        } else {
            LPMobileLog.e((String)TAG, (String)"updateMessageByRowIdOnDbThread - message does not exist");
        }
    }

    public DataBaseCommand<Void> updateFileMessageByRowId(final long messageRowId, final long fileRowId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                MessagingChatMessage message = AmsMessages.this.getMessageByRowIdOnDbThread(messageRowId);
                AmsMessages.this.getMessagesListener().onUpdateMessage(AmsMessages.this.createFullMessageRow(messageRowId, message, fileRowId));
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private MessagingChatMessage getMessageByRowIdOnDbThread(long messageRowId) {
        Cursor cursor = this.getDB().query(null, "_id = ?", new String[]{String.valueOf(messageRowId)}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    MessagingChatMessage messagingChatMessage = AmsMessages.getSingleMessageFromCursor(cursor);
                    return messagingChatMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    private void updateMessageByRowId(long rowId, MessagingChatMessage message) {
        this.getMessagesListener().onUpdateMessage(this.createFullMessageRow(rowId, message, -1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllMessagesForDialog(String dialogId) {
        Cursor cursor = this.getDB().query(new String[]{"MIN(timeStamp)", "MAX(timeStamp)"}, "dialogId = ?", new String[]{dialogId}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    long firstMessageTimestampForConversation = cursor.getLong(0);
                    long lastMessageTimestampForConversation = cursor.getLong(1);
                    this.getMessagesListener().onUpdateMessages(firstMessageTimestampForConversation, lastMessageTimestampForConversation);
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    public void updateFetchHistoryEnded(String brandId) {
        this.updateFetchHistoryEnded(brandId, true);
    }

    public void updateFetchHistoryEnded(String brandId, final boolean updated) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (updated) {
                    AmsMessages.this.getMessagesListener().onHistoryFetched();
                } else {
                    AmsMessages.this.getMessagesListener().onHistoryFetchedFailed();
                }
            }
        });
    }

    public void updateAgentDetailsUpdated(String brandId, String dialogId) {
        this.updateAllMessagesForDialog(dialogId);
    }

    public void updateHandledExConversation(String brandId, boolean emptyNotification) {
        this.getMessagesListener().onExConversationHandled(emptyNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimestampMessage(String dialogId, int sequence) {
        long timestamp = 0L;
        Cursor cursor = this.getDB().rawQuery("SELECT timeStamp FROM messages WHERE dialogId =? AND serverSequence =? ", new Object[]{dialogId, sequence});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    timestamp = cursor.getLong(cursor.getColumnIndex("timeStamp"));
                }
            }
            finally {
                cursor.close();
            }
        }
        return timestamp;
    }

    public void shutDown() {
        this.mMessageTimeoutQueue.removeAll();
    }

    public void clear() {
    }

    public static interface MessagesListener {
        public void initMessages(ArrayList<FullMessageRow> var1);

        public void onQueryMessagesResult(long var1, long var3);

        public void onUpdateMessages(long var1, long var3);

        public void onNewMessage(FullMessageRow var1);

        public void onUpdateMessage(FullMessageRow var1);

        public void removeAll(String var1);

        public void onHistoryFetched();

        public void onExConversationHandled(boolean var1);

        public void onHistoryFetchedFailed();
    }

    public static enum MessagesSortedBy {
        TargetId,
        ConversationId;

    }
}

