/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.Utils.ClockUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.network.http.AgentProfileRequest;
import java.text.DateFormat;
import java.util.Date;

public class DialogUtils {
    private static final String TAG = DialogUtils.class.getSimpleName();
    protected final Messaging mController;
    private final DateFormat mFormatter;

    public DialogUtils(Messaging controller) {
        this.mController = controller;
        String customFormat = Configuration.getString((int)R.string.lp_date_time_format);
        this.mFormatter = DateUtils.getDateFormat((String)customFormat, (int)3, (int)3);
    }

    public void addClosedDialogDivider(String brandId, Dialog dialog, String assignedAgentServerId, CloseReason resolvedBy, boolean updateUI, @Nullable ICallback<Void, Exception> callback) {
        Object originatorId = resolvedBy == CloseReason.CONSUMER ? this.mController.getOriginatorId(brandId) : (resolvedBy == CloseReason.TIMEOUT || resolvedBy == CloseReason.SYSTEM ? null : assignedAgentServerId);
        this.addResolvedDivider(brandId, dialog, (String)originatorId, resolvedBy, updateUI, callback);
    }

    protected String getResolveTextMessage(String message, long timestamp, String agentName) {
        String time = this.mFormatter.format(new Date(timestamp));
        if (!TextUtils.isEmpty((CharSequence)agentName)) {
            return String.format(message, agentName, time);
        }
        return String.format(message, time);
    }

    private void addResolvedDivider(final String targetId, final Dialog dialog, final String originatorId, CloseReason resolvedBy, final boolean updateUI, final @Nullable ICallback<Void, Exception> callback) {
        final long timestamp = ClockUtils.addDiffToTimestamp(dialog.getEndTimestamp());
        if (dialog.getDialogType() == DialogType.MAIN) {
            if (resolvedBy == CloseReason.CONSUMER) {
                String resolvedByName = Configuration.getString((int)R.string.lp_conversation_ended_by_you);
                String resolvedMsg = this.getResolveTextMessage(resolvedByName, timestamp, null);
                this.addResolveMessage(targetId, dialog.getDialogId(), timestamp, resolvedMsg, originatorId, updateUI, MessagingChatMessage.MessageType.SYSTEM_RESOLVED, callback);
            } else if (resolvedBy == CloseReason.TIMEOUT || resolvedBy == CloseReason.SYSTEM) {
                LPMobileLog.d((String)TAG, (String)"This conversation was Auto closed - Don't add Resolved message");
                if (callback != null) {
                    callback.onError((Throwable)new Exception("This conversation timed out or Auto closed"));
                }
            } else {
                this.mController.amsUsers.getUserById(originatorId).setPostQueryOnUI((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingUserProfile>(){

                    public void onResult(MessagingUserProfile data) {
                        String agentNickName = null;
                        if (data != null) {
                            agentNickName = data.getNickname();
                        }
                        String resolvedMsg = !TextUtils.isEmpty(agentNickName) ? Configuration.getString((int)R.string.lp_conversation_ended_by_agent_with_name) : Configuration.getString((int)R.string.lp_conversation_ended_by_agent_no_name);
                        resolvedMsg = DialogUtils.this.getResolveTextMessage(resolvedMsg, timestamp, agentNickName);
                        DialogUtils.this.addResolveMessage(targetId, dialog.getDialogId(), timestamp, resolvedMsg, originatorId, updateUI, MessagingChatMessage.MessageType.SYSTEM_RESOLVED, callback);
                    }
                }).execute();
            }
        } else {
            this.addResolveMessage(targetId, dialog.getDialogId(), timestamp, "dialog closed", originatorId, updateUI, MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED, callback);
        }
    }

    private void addResolveMessage(String targetId, String dialogId, long timestamp, String message, String originatorId, boolean updateUI, MessagingChatMessage.MessageType messageType, final ICallback callback) {
        LPMobileLog.d((String)TAG, (String)("creating message resolve at time: " + timestamp + " timestamp: " + timestamp));
        String eventId = timestamp + "_" + -2;
        MessagingChatMessage systemResolved = new MessagingChatMessage(originatorId, message, timestamp, dialogId, eventId, messageType, MessagingChatMessage.MessageState.RECEIVED, EncryptionVersion.NONE);
        systemResolved.setServerSequence(-2);
        this.mController.amsMessages.addMessage(targetId, systemResolved, updateUI).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Long>(){

            public void onResult(Long data) {
                if (callback != null) {
                    callback.onSuccess(null);
                }
            }
        }).execute();
    }

    public void updateParticipants(String targetId, String brandId, String[] participants, UserProfile.UserType userType, String dialogId, boolean updateUI, boolean forceUpdate) {
        this.updateParticipants(targetId, brandId, participants, userType, dialogId, updateUI, forceUpdate, null);
    }

    public void updateParticipants(final String targetId, final String brandId, String[] participants, final UserProfile.UserType userType, final String dialogId, final boolean updateUI, final boolean forceUpdate, final ICallback<MessagingUserProfile, Exception> callback) {
        for (final String userId : participants) {
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                this.mController.amsUsers.getUserById(userId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingUserProfile>(){

                    public void onResult(MessagingUserProfile userProfile) {
                        if (userProfile == null || userProfile.isEmptyUser() || forceUpdate) {
                            userProfile = new MessagingUserProfile("", "", userType);
                            userProfile.setOriginatorID(userId);
                            DialogUtils.this.mController.amsUsers.updateUserProfile(userProfile);
                            LPMobileLog.i((String)TAG, (String)("First time bringing information for another participant that joined dialog " + dialogId));
                            DialogUtils.this.sendUpdateUserRequest(targetId, brandId, userId, dialogId, updateUI, (ICallback<MessagingUserProfile, Exception>)callback);
                        } else if (callback != null) {
                            callback.onSuccess((Object)userProfile);
                        }
                    }
                }).execute();
                continue;
            }
            LPMobileLog.e((String)TAG, (String)"Missing agent ID!");
        }
    }

    private void sendUpdateUserRequest(String targetId, String brandId, String userId, String dialogId, boolean shouldUpdateUi, ICallback<MessagingUserProfile, Exception> callback) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            new AgentProfileRequest(this.mController, targetId, userId, dialogId, shouldUpdateUi).setCallback(callback).execute();
        } else {
            if (TextUtils.isEmpty((CharSequence)dialogId)) {
                LPMobileLog.d((String)TAG, (String)"sendUpdateUserRequest: no dialog id");
                return;
            }
            this.mController.amsDialogs.queryDialogById(dialogId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Dialog>(){

                public void onResult(Dialog dialog) {
                    LPMobileLog.d((String)TAG, (String)"onResult: Calling agent details callback with null agent");
                    DialogUtils.this.mController.onAgentDetailsChanged(null, dialog.isOpen());
                }
            }).execute();
        }
    }
}

