/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.LPAuthenticationParams;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.IdpTask;
import com.liveperson.messaging.model.AmsAccount;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONException;
import org.json.JSONObject;

public class IdpRequest
implements Command {
    public static final String TAG = IdpRequest.class.getSimpleName();
    protected static final int IDP_REQUEST_TIMEOUT = 30000;
    protected static final String SIGNUP = "signup";
    protected static final String AUTHENTICATE = "authenticate";
    protected static final String DEFAULT_REDIRECT_URI = "https://liveperson.net";
    public static final String USER_EXPIRED_ERROR = "2001";
    private static final String IDP_URL = "https://%s/api/account/%s/app/default/%s?v=2.0";
    protected final AmsAccount mAccount;
    protected String mIdpDomain;
    protected String mBrandId;
    protected IdpTask.IDPExceptionICallback mCallback;
    protected LPAuthenticationParams mLPAuthenticationParams = null;
    protected String mHostVersion;
    protected List<String> mCertificates;

    public IdpRequest(AmsAccount account, String idpDomain, String brandId, LPAuthenticationParams lpAuthenticationParams, String hostVersion, IdpTask.IDPExceptionICallback callback, List<String> certificates) {
        this.mIdpDomain = idpDomain;
        this.mBrandId = brandId;
        this.mCallback = callback;
        this.mHostVersion = hostVersion;
        this.mCertificates = certificates;
        this.mAccount = account;
        this.mLPAuthenticationParams = lpAuthenticationParams;
    }

    public void execute() {
        HttpPostRequest httpPostRequest = null;
        LPAuthenticationParams.LPAuthenticationType authType = LPAuthenticationParams.LPAuthenticationType.SIGN_UP;
        if (this.mLPAuthenticationParams != null) {
            authType = this.mLPAuthenticationParams.getAuthType();
        }
        switch (authType) {
            case AUTH: {
                String hostAppJWT = this.mLPAuthenticationParams.getHostAppJWT();
                String authKey = this.mLPAuthenticationParams.getAuthKey();
                if (TextUtils.isEmpty((CharSequence)hostAppJWT) && TextUtils.isEmpty((CharSequence)authKey)) {
                    LPMobileLog.e((String)TAG, (String)"execute: both hostAppJWT and authKey are empty. Cannot continue");
                    this.sendErrorCallback(new Exception("No JWT nor authKey was provided to AUTH authentication. Cannot authenticate"));
                    return;
                }
                httpPostRequest = this.getHttpPostRequestForIDPV2(hostAppJWT, authKey);
                this.sendGeneralRequest(httpPostRequest);
                break;
            }
            case SIGN_UP: {
                httpPostRequest = this.getHttpPostRequestForSignUp();
                this.sendGeneralRequest(httpPostRequest);
                break;
            }
        }
    }

    protected void sendErrorCallback(Exception exception) {
        LPMobileLog.e((String)TAG, (String)exception.getMessage());
        if (exception instanceof SSLPeerUnverifiedException) {
            this.mCallback.onError(TaskType.INVALID_CERTIFICATE, exception);
        } else {
            this.mCallback.onError(TaskType.IDP, exception);
        }
    }

    protected void sendGeneralRequest(HttpPostRequest httpPostRequest) {
        if (httpPostRequest != null) {
            httpPostRequest.setCertificatePinningKeys(this.mCertificates);
            LPMobileLog.d((String)TAG, (String)("IDP request url : " + httpPostRequest.getUrl()));
            httpPostRequest.setTimeout(30000);
            this.addHeaders(httpPostRequest);
            HttpHandler.execute((HttpRequest)httpPostRequest);
        }
    }

    @NonNull
    private HttpPostRequest getHttpPostRequestForIDPV2(String hostAppJWT, String authKey) {
        JSONObject jsonBody = null;
        if (!TextUtils.isEmpty((CharSequence)hostAppJWT)) {
            jsonBody = this.getBodyForIDPJwtFlow(hostAppJWT);
        } else if (!TextUtils.isEmpty((CharSequence)authKey)) {
            jsonBody = this.getBodyForIDPAuthCodeFlow(authKey, this.mLPAuthenticationParams.getHostAppRedirectUri());
        }
        LPMobileLog.d((String)TAG, (String)("Idp json body: " + jsonBody.toString()));
        String idpUrl = String.format(IDP_URL, this.mIdpDomain, this.mBrandId, AUTHENTICATE);
        final HttpPostRequest httpPostRequest = new HttpPostRequest(idpUrl);
        LPJSONObjectBody body = new LPJSONObjectBody(jsonBody);
        httpPostRequest.setBody((HttpRequestBody)body);
        httpPostRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String idpResponse) {
                LPMobileLog.d((String)TAG, (String)("onSuccess " + idpResponse));
                if (!TextUtils.isEmpty((CharSequence)idpResponse)) {
                    try {
                        JSONObject idpJson = new JSONObject(idpResponse);
                        String token = idpJson.getString("token");
                        IdpRequest.this.mCallback.onSuccess(token);
                    }
                    catch (JSONException je) {
                        LPMobileLog.d((String)TAG, (String)("JSONException: " + je.getMessage()));
                        String errorMsg = "idp url = " + httpPostRequest.getUrl() + ". Exception " + je.getMessage();
                        IdpRequest.this.sendErrorCallback(new Exception(errorMsg));
                    }
                }
            }

            public void onError(Exception e) {
                LPMobileLog.d((String)TAG, (String)("Error: idp url = " + httpPostRequest.getUrl() + ". Exception " + e.getMessage()));
                IdpRequest.this.sendErrorCallback(e);
            }
        });
        return httpPostRequest;
    }

    @NonNull
    private JSONObject getBodyForIDPAuthCodeFlow(String authKey, String hostAppRedirectUri) {
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("code", (Object)authKey);
            jsonBody.put("redirect_uri", (Object)(TextUtils.isEmpty((CharSequence)hostAppRedirectUri) ? DEFAULT_REDIRECT_URI : hostAppRedirectUri));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonBody;
    }

    @NonNull
    protected JSONObject getBodyForIDPJwtFlow(String jwt) {
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("id_token", (Object)jwt);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonBody;
    }

    @NonNull
    private HttpPostRequest getHttpPostRequestForSignUp() {
        String IDP_URL = "https://%s/api/account/%s/%s?v=1.0";
        String idpUrl = String.format(IDP_URL, this.mIdpDomain, this.mBrandId, SIGNUP);
        final HttpPostRequest httpPostRequest = new HttpPostRequest(idpUrl);
        httpPostRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String idpResponse) {
                LPMobileLog.d((String)TAG, (String)("onSuccess " + idpResponse));
                if (!TextUtils.isEmpty((CharSequence)idpResponse)) {
                    try {
                        JSONObject idpJson = new JSONObject(idpResponse);
                        String token = idpJson.getString("jwt");
                        IdpRequest.this.mCallback.onSuccess(token);
                    }
                    catch (JSONException je) {
                        LPMobileLog.d((String)TAG, (String)("JSONException: " + je.getMessage()));
                        String errorMsg = "idp url = " + httpPostRequest.getUrl() + ". Exception " + je.getMessage();
                        IdpRequest.this.sendErrorCallback(new Exception(errorMsg));
                    }
                }
            }

            public void onError(Exception e) {
                LPMobileLog.d((String)TAG, (String)("Error: idp url = " + httpPostRequest.getUrl() + ". Exception " + e.getMessage()));
                IdpRequest.this.sendErrorCallback(e);
            }
        });
        return httpPostRequest;
    }

    protected void addHeaders(HttpPostRequest httpPostRequest) {
        httpPostRequest.addHeader("sdkVersion", this.mHostVersion);
        httpPostRequest.addHeader("platform", "Android");
        httpPostRequest.addHeader("platformVer", String.valueOf(Build.VERSION.SDK_INT));
        httpPostRequest.addHeader("device", Build.MODEL);
        httpPostRequest.addHeader("applicationId", this.mBrandId.replace("\n", ""));
    }
}

