/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket;

import android.os.Bundle;
import android.webkit.URLUtil;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.api.response.events.MessagingEventNotification;
import com.liveperson.api.response.model.Event;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.MessagingEventNotificationHandler$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00030\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0016\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\n\n\u0002\b\u000b\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/liveperson/messaging/network/socket/MessagingEventNotificationHandler;", "Lcom/liveperson/infra/network/socket/BaseResponseHandler;", "Lcom/liveperson/api/response/events/MessagingEventNotification;", "Lcom/liveperson/infra/network/socket/BaseSocketRequest;", "mController", "Lcom/liveperson/messaging/Messaging;", "(Lcom/liveperson/messaging/Messaging;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "TAG$1", "getMController$messaging_release", "()Lcom/liveperson/messaging/Messaging;", "setMController$messaging_release", "extractLinks", "", "text", "(Ljava/lang/String;)[Ljava/lang/String;", "getAPIResponseType", "handle", "", "event", "parse", "jsonObject", "Lorg/json/JSONObject;", "Companion", "messaging_release"})
public final class MessagingEventNotificationHandler
extends BaseResponseHandler<MessagingEventNotification, BaseSocketRequest<?, ?>> {
    @NotNull
    private final String TAG$1 = "MessagingEvent";
    @NotNull
    private Messaging mController;
    private static final String TAG;
    @NotNull
    private static final String AGENT_TYPING_ACTION = "agent_typing";
    @NotNull
    private static final String AGENT_TYPING_ACTION_IS_TYPING_EXTRA = "is_typing";
    @NotNull
    private static final String ORIGINATOR_ID_EXTRA = "originator_id";
    public static final Companion Companion;

    @NotNull
    public final String getTAG() {
        return this.TAG$1;
    }

    @NotNull
    public String getAPIResponseType() {
        return "ms.MessagingEventNotification";
    }

    @Nullable
    protected MessagingEventNotification parse(@NotNull JSONObject jsonObject) throws JSONException {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        MessagingEventNotification responseBody = null;
        try {
            responseBody = new MessagingEventNotification(jsonObject);
        }
        catch (JSONException e) {
            LPMobileLog.e((String)this.TAG$1, (String)e.getMessage());
        }
        return responseBody;
    }

    protected boolean handle(@NotNull MessagingEventNotification event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (((ArrayList)event.getBody()).isEmpty()) {
            return true;
        }
        String dialogId = ((ContentEventNotification)((ArrayList)event.getBody()).get((int)0)).dialogId;
        MessagingEventSubscriptionManager messagingEventSubscriptionManager = this.mController.getMessagingEventSubscriptionManager();
        String string2 = dialogId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dialogId");
        boolean firstNotification = messagingEventSubscriptionManager.onReceivedEvent(string2);
        boolean shouldUpdateUi = this.mController.getMessagingEventSubscriptionManager().shouldUpdateUI(dialogId);
        this.mController.amsDialogs.saveMessagesResult(dialogId, (ArrayList<ContentEventNotification>)event.getBody(), firstNotification, shouldUpdateUi, (ICallback<Dialog, Exception>)((ICallback)new ICallback<Dialog, Exception>(this, event, dialogId){
            final /* synthetic */ MessagingEventNotificationHandler this$0;
            final /* synthetic */ MessagingEventNotification $event;
            final /* synthetic */ String $dialogId;

            public void onSuccess(@Nullable Dialog dialog) {
                Messaging messaging = this.this$0.getMController$messaging_release();
                Dialog dialog2 = dialog;
                if (dialog2 == null) {
                    Intrinsics.throwNpe();
                }
                String consumerId = messaging.getOriginatorId(dialog2.getTargetId());
                Iterable $receiver$iv = (Iterable)this.$event.getBody();
                for (T element$iv : $receiver$iv) {
                    ContentEventNotification it = (ContentEventNotification)element$iv;
                    boolean bl = false;
                    LPMobileLog.d((String)this.this$0.getTAG(), (String)("saving message in dialog " + this.$dialogId));
                    Event.Types eventType = it.event.type;
                    String originatorId = it.originatorId;
                    Event.Types types = eventType;
                    if (types == null) continue;
                    switch (MessagingEventNotificationHandler$WhenMappings.$EnumSwitchMapping$1[types.ordinal()]) {
                        case 1: {
                            if (!(Intrinsics.areEqual((Object)originatorId, (Object)consumerId) ^ true)) break;
                            boolean isTyping = false;
                            ChatState chatState = it.event.chatState;
                            if (chatState != null) {
                                switch (MessagingEventNotificationHandler$WhenMappings.$EnumSwitchMapping$0[chatState.ordinal()]) {
                                    case 1: {
                                        isTyping = true;
                                        break;
                                    }
                                    case 2: {
                                        isTyping = false;
                                    }
                                }
                            }
                            Bundle agentBundle = new Bundle();
                            agentBundle.putBoolean(MessagingEventNotificationHandler.Companion.getAGENT_TYPING_ACTION_IS_TYPING_EXTRA(), isTyping);
                            agentBundle.putString(MessagingEventNotificationHandler.Companion.getORIGINATOR_ID_EXTRA(), originatorId);
                            LocalBroadcast.sendBroadcast((String)MessagingEventNotificationHandler.Companion.getAGENT_TYPING_ACTION(), (Bundle)agentBundle);
                            this.this$0.getMController$messaging_release().mEventsProxy.onAgentTyping(isTyping);
                        }
                    }
                }
            }

            public void onError(@Nullable Exception exception) {
            }
            {
                this.this$0 = $outer;
                this.$event = $captured_local_variable$1;
                this.$dialogId = $captured_local_variable$2;
            }
        }));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] extractLinks(@NotNull String text) {
        List list;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        ArrayList<String> links = new ArrayList<String>();
        Object object = text;
        String string2 = "\\s+";
        string2 = new Regex(string2);
        int n = 0;
        object = string2.split((CharSequence)object, n);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                CharSequence charSequence = it;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $receiver$iv = list;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv22 = collection;
        String[] stringArray = thisCollection$iv22.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] l = stringArray;
        int $receiver$iv2 = 0;
        int thisCollection$iv22 = l.length;
        while ($receiver$iv2 < thisCollection$iv22) {
            void i;
            if (URLUtil.isValidUrl((String)l[i])) {
                links.add(l[i]);
            }
            ++i;
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)links;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray2;
    }

    @NotNull
    public final Messaging getMController$messaging_release() {
        return this.mController;
    }

    public final void setMController$messaging_release(@NotNull Messaging messaging) {
        Intrinsics.checkParameterIsNotNull((Object)messaging, (String)"<set-?>");
        this.mController = messaging;
    }

    public MessagingEventNotificationHandler(@NotNull Messaging mController) {
        Intrinsics.checkParameterIsNotNull((Object)mController, (String)"mController");
        this.mController = mController;
        this.TAG$1 = "MessagingEvent";
    }

    static {
        Companion = new Companion(null);
        TAG = MessagingEventNotificationHandler.class.getSimpleName();
        AGENT_TYPING_ACTION = AGENT_TYPING_ACTION;
        AGENT_TYPING_ACTION_IS_TYPING_EXTRA = AGENT_TYPING_ACTION_IS_TYPING_EXTRA;
        ORIGINATOR_ID_EXTRA = ORIGINATOR_ID_EXTRA;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/liveperson/messaging/network/socket/MessagingEventNotificationHandler$Companion;", "", "()V", "AGENT_TYPING_ACTION", "", "getAGENT_TYPING_ACTION", "()Ljava/lang/String;", "AGENT_TYPING_ACTION_IS_TYPING_EXTRA", "getAGENT_TYPING_ACTION_IS_TYPING_EXTRA", "ORIGINATOR_ID_EXTRA", "getORIGINATOR_ID_EXTRA", "TAG", "kotlin.jvm.PlatformType", "messaging_release"})
    public static final class Companion {
        @NotNull
        public final String getAGENT_TYPING_ACTION() {
            return AGENT_TYPING_ACTION;
        }

        @NotNull
        public final String getAGENT_TYPING_ACTION_IS_TYPING_EXTRA() {
            return AGENT_TYPING_ACTION_IS_TYPING_EXTRA;
        }

        @NotNull
        public final String getORIGINATOR_ID_EXTRA() {
            return ORIGINATOR_ID_EXTRA;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

