package com.liveperson.api.request;

import com.liveperson.api.response.AbstractResponse;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.api.exception.BadMessageException;
import com.liveperson.infra.log.LPMobileLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by Shayl on 8/9/2015.
 */
public class QueryMessages extends AbstractRequest {

    public static final String DIALOG_ID = "dialogId";
    public static final String MAX_QUANTITY = "maxQuantity";
    public static final String OLDER_THAN_SEQUENCE = "olderThanSequence";
    public static final String NEWER_THAN_SEQUENCE = "newerThanSequence";
    public static final String SEQUENCE = "sequence";
    public static final String ORIGINATOR_ID = "originatorId";
    public static final String SERVER_TIMESTAMP = "serverTimestamp";
    public static final String EVENT = "event";
    public static final String SEQUENCE1 = "sequence";
    public static final String BODY = "body";
    private static final String QUERY_MESSAGES_TYPE = ".ams.ms.QueryMessages";

    public String dialogId;
    public int maxQuantity;
    public long olderThanSequence;
    public long newerThanSequence;

    public QueryMessages(String dId, int maxQ, long olderThan, long newerThan) {
        dialogId = dId;
        maxQuantity = maxQ;
        olderThanSequence = olderThan;
        newerThanSequence = newerThan;
    }


    @Override
    public String getMessageType() {
        return QUERY_MESSAGES_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        body.put(DIALOG_ID, dialogId);
        if (maxQuantity != -1){
            body.put(MAX_QUANTITY, maxQuantity);
        }
        if (olderThanSequence != -1){
            body.put(OLDER_THAN_SEQUENCE, olderThanSequence);
        }
        body.put(NEWER_THAN_SEQUENCE, newerThanSequence);
        json.put(AbstractRequest.JSON_KEY_BODY, body);
    }

    public static class Response extends AbstractResponse {

        public static final String QUERY_MESSAGES_RESPONSE_TYPE = QUERY_MESSAGES_TYPE + GENERAL_INNER_RESPONSE;
        private static final String TAG = "QueryMessagesResponse";

        ArrayList<ContentEventNotification> body;

        public Response(JSONObject obj) throws JSONException {
            super(obj);
            JSONArray bodyArr = obj.getJSONArray(BODY);
            parseContent(bodyArr);
        }
        public Response(JSONArray obj) throws JSONException {
            super(null);
            parseContent(obj);
        }
        private void parseContent(JSONArray bodyArr) throws JSONException {
            body = new ArrayList<>(bodyArr.length());
            for (int i = 0; i < bodyArr.length(); i++) {
                try {
                    body.add(new ContentEventNotification(bodyArr.getJSONObject(i)));
                } catch (BadMessageException e) {
                    LPMobileLog.w(TAG, "Bad message: "+ e.getMessage());
                }
            }
        }

        public ArrayList<ContentEventNotification> getBody() {
            return body;
        }
    }
}