package com.liveperson.api.response.model;

import com.liveperson.infra.log.LPMobileLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 9/5/17.
 */

public class OriginatorMetadata {

	public static final String TAG = OriginatorMetadata.class.getSimpleName();

	private static final String ID = "id";
	private static final String ROLE = "role";

	public String mId;

	public Participants.ParticipantRole mRole;

	/**
	 * Parse the given JSONObject and return {@link OriginatorMetadata} object, or null if cannot parse or missing mandatory info
	 * @param jsonObject
	 * @return
	 */
	public static OriginatorMetadata fromJson(JSONObject jsonObject) {

		if (jsonObject == null) {
			LPMobileLog.d(TAG, "fromJson: no OriginatorMetadata content");
			return null;
		}

		OriginatorMetadata originatorMetadata = new OriginatorMetadata();

		try {
			originatorMetadata.mId = jsonObject.getString(ID);

			originatorMetadata.mRole = Participants.ParticipantRole.valueOf(jsonObject.getString(ROLE));

		} catch (JSONException e) {
			LPMobileLog.e(TAG, "fromJson: missing mandatory information", e);
			return null;
		}

		return originatorMetadata;
	}
}
