package com.liveperson.api.response.model;

import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by shayl on 8/10/15.
 */
public class UserProfile {

    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String NICKNAME = "nickname";
    public static final String USER_ID = "userId";
    public static final String AVATAR_URL = "avatarUrl";
    public static final String ROLE = "role";
    public static final String BACKGND_IMG_URI = "backgndImgUri";
    public static final String DESCRIPTION = "description";
    public static final String PRIVATE_DATA = "privateData";
    public static final String SERVICE_NAME = "serviceName";
    public static final String CERT_NAME = "certName";
    public static final String TOKEN = "token";
    public static final String MAIL = "mail";
    public static final String PUSH_NOTIFICATION_DATA = "pushNotificationData";
    public static final String MOBILE_NUM = "mobileNum";
    //Basic parameters
    private String firstName;
    private String lastName;
    private String nickname;
    private UserType userType;
    private long localId;
    private String originatorId; //Server id for recognizing userProfile
    private String avatarUrl;
    private String role;
    private String backgndImgUri;
    private String description;
    private long requestId;
    private PrivateData privateData;
    //basic constructor
    public UserProfile(String firstName, String lastName, UserType type) {
        setFirstName(firstName);
        setLastName(lastName);
        setUserType(type);

        //Empty Private data
        setPrivateData(new UserProfile.PrivateData("", ""));
    }

    public UserProfile(JSONObject src) throws JSONException {
        setOriginatorID(src.getString(USER_ID));
        if (TextUtils.isEmpty(originatorId)){
            throw new JSONException("no originator id");
        }
        setFirstName(src.getString(FIRST_NAME));
        setLastName(src.getString(LAST_NAME));
        setAvatarUrl(src.getString(AVATAR_URL));
        setRole(src.getString(ROLE));
        setBackgndImgUri(src.getString(BACKGND_IMG_URI));
        setDescription(src.getString(DESCRIPTION));

        //only we as user profile have private data . when we get the agent profile its null
        if (!src.isNull(PRIVATE_DATA)) {
            setPrivateData(new PrivateData(src.getJSONObject(PRIVATE_DATA)));
        }
    }

    public void addToJson(JSONObject json) throws JSONException {
        json.put(FIRST_NAME, firstName);
        json.put(LAST_NAME, lastName);
        json.put(USER_ID, originatorId);
        json.put(AVATAR_URL, avatarUrl);
        json.put(ROLE, role);
        json.put(BACKGND_IMG_URI, backgndImgUri);
        json.put(DESCRIPTION, description);


        //Private Data
        JSONObject privateDataJson = new JSONObject();
        privateData.addToJson(privateDataJson);
        json.put(PRIVATE_DATA, privateDataJson);
    }

    /**
     * All Getters
     */
    public String getFirstName() {
        return firstName;
    }

    /**
     * All Setters
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getOriginatorId() {
        return originatorId;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        if (TextUtils.isEmpty(avatarUrl) || avatarUrl.equalsIgnoreCase("null")){
            avatarUrl = "";
        }
        this.avatarUrl = avatarUrl;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getBackgndImgUri() {
        return backgndImgUri;
    }

    public void setBackgndImgUri(String backgndImgUri) {
        if (TextUtils.isEmpty(backgndImgUri) || backgndImgUri.equalsIgnoreCase("null")){
            backgndImgUri = "";
        }
        this.backgndImgUri = backgndImgUri;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PrivateData getPrivateData() {
        return privateData;
    }

    public void setPrivateData(PrivateData privateData) {
        this.privateData = privateData;
    }

    public UserType getUserType() {
        return userType;
    }

    public void setUserType(UserType type) {
        this.userType = type;
    }

    public long getRequestId() {
        return requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public long getLocalId() {
        return this.localId;
    }

    public void setLocalId(long id) {
        this.localId = id;
    }

    public String getFullName() {
        return getFirstName() + " " + getLastName();
    }

    public String getEmail() {
        return privateData.mail;
    }

    public void setEmail(String email) {
        this.privateData.mail = email;
    }

    public void setMobileNumber(String mobileNumber) {
        this.privateData.mobileNum = mobileNumber;
    }

    public void setOriginatorID(String originatorId) {
        this.originatorId = originatorId;
    }

    public enum UserType {CONSUMER, AGENT, CONTROLLER}

    public static class PushNotificationData {
        public String serviceName = "";
        public String certName = "";
        public String token = "";

        public PushNotificationData(String serviceName, String certName, String token) {
            this.serviceName = serviceName;
            this.certName = certName;
            this.token = token;
        }

        public PushNotificationData(JSONObject src) throws JSONException {
            serviceName = src.getString(SERVICE_NAME);
            certName = src.getString(CERT_NAME);
            token = src.getString(TOKEN);
        }

        public void addToJson(JSONObject json) throws JSONException {
            json.put(SERVICE_NAME, serviceName);
            json.put(CERT_NAME, certName);
            json.put(TOKEN, token);
        }
    }

    public static class PrivateData {
        public String mobileNum = "";
        public String mail = "";

        public  PrivateData(String mobileNum, String mail) {
            this.mobileNum = mobileNum;
            this.mail = mail;
        }


        public PrivateData(JSONObject src) throws JSONException {
            mobileNum = src.getString(MOBILE_NUM);
            mail = src.getString(MAIL);
        }

        public void addToJson(JSONObject json) throws JSONException {
            json.put(MOBILE_NUM, TextUtils.isEmpty(mobileNum) ? JSONObject.NULL : mobileNum);
            json.put(MAIL, TextUtils.isEmpty(mail) ? JSONObject.NULL : mail);
			// Actually we don't need to send the PUSH_NOTIFICATION_DATA here, but due to a bug in the UMS
			// we need to send it as null object
			json.put(PUSH_NOTIFICATION_DATA, JSONObject.NULL);
        }
    }
}
