package com.liveperson.api.response.types;

import android.text.TextUtils;

import com.liveperson.infra.log.LPMobileLog;

public enum DialogType {
    MAIN, POST_SURVEY, AGENT, OTHER;

    private static final String TAG = DialogType.class.getSimpleName();

    public static DialogType parse(int ordinal) {
        DialogType result = MAIN;

        DialogType[] values = DialogType.values();
        if (ordinal < values.length) {
            result = values[ordinal];
        }

        return result;
    }

    public static DialogType parse(String dialogTypeString) {
        DialogType result = MAIN;
        if (TextUtils.isEmpty(dialogTypeString)) return result;

        try {
            result = DialogType.valueOf(dialogTypeString);
        } catch (Exception e) {
            LPMobileLog.e(TAG, "Failed to parse DialogType from string: " + dialogTypeString);
            DialogType[] values = values();
            for (DialogType dialogType : values) {
                if (dialogType.name().equalsIgnoreCase(dialogTypeString)) {
                    result = dialogType;
                    break;
                }
            }
        }

        return result;
    }
}
