package com.liveperson.messaging.background.filesharing;

/**
 * Describes the type of file to be shared
 */
public enum FileSharingType {
    PDF(CommonFileType.DOCUMENT),
    DOCX(CommonFileType.DOCUMENT), PPTX(CommonFileType.DOCUMENT), XLSX(CommonFileType.DOCUMENT),
    JPEG(CommonFileType.IMAGE), JPG(CommonFileType.IMAGE), PNG(CommonFileType.IMAGE), GIF(CommonFileType.IMAGE),
    VOICE(CommonFileType.AUDIO), UNKNOWN(CommonFileType.NOT_SUPPORTED);

    private CommonFileType mCommonFileType;

    FileSharingType(CommonFileType commonFileType) {
        this.mCommonFileType = commonFileType;
    }

    public CommonFileType getCommonFileType() {
        return mCommonFileType;
    }

    public enum CommonFileType {
        IMAGE,//common for JPEG,JPG,PNG,GIF
        DOCUMENT,//common for PDF,DOCX,PPTX,XLSX
        AUDIO, //common for VOICE
        NOT_SUPPORTED
    }
}
