package com.liveperson.messaging.commands;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;
import com.liveperson.messaging.network.socket.requests.QueryMessagesRequest;

/**
 * Created by shiranr on 14/01/2016.
 */
public class QueryMessagesUMSCommand extends BasicQueryMessagesCommand {

    private static final String TAG = QueryMessagesUMSCommand.class.getSimpleName();
    private static final int INFINITY = -2;
    private static final int CHUNK = 1000;
    private int lastCurrentSequence;
    private int unreadMessages;
    private int lastServerSequence;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;

    public QueryMessagesUMSCommand(Messaging controller, String brandId, String targetId, String conversationId, String dialogId, int lastCurrentSequence, boolean updateUI) {
        super(controller, brandId, targetId, conversationId, dialogId, updateUI);

        this.lastCurrentSequence = lastCurrentSequence;
        /*if (lastServerSequence == -1){
            this.lastServerSequence = CHUNK -2;
            unreadMessages = CHUNK;
        }else{
            this.lastServerSequence = lastServerSequence;
            unreadMessages = lastServerSequence - lastCurrentSequence;
        }*/

    }

    @Override
    public void execute() {

        LPMobileLog.d(TAG,"Sending query messages from sequence " + lastCurrentSequence );
        controller.getMessagingEventSubscriptionManager().addSubscription(controller, brandID, conversationId, dialogId, lastCurrentSequence, mUpdateUI);
    }

    private void queryMessages() {
        int from = lastCurrentSequence;
        int to;
        QueryMessagesRequest baseSocketRequest;

        while(unreadMessages > 0){
            to = from + CHUNK;
            if (to > lastServerSequence){
                to = INFINITY;//lastServerSequence;
            }

            LPMobileLog.d(TAG,"Sending query messages from sequence " + from + " to " + (to == INFINITY ? "infinity" : to));
            baseSocketRequest = new QueryMessagesRequest(controller, brandID, targetId, dialogId, from);
            if (to == INFINITY) {
                to = lastServerSequence;
            } else {
                baseSocketRequest.setOlderThanSequenceId(to);
                baseSocketRequest.setMaxSize(to - from);
            }
            baseSocketRequest.setShouldUpdateUI(mUpdateUI);
            baseSocketRequest.setResponseCallBack(mResponseCallBack);
            SocketManager.getInstance().send(baseSocketRequest);

            from = to;
            unreadMessages = lastServerSequence - to;
        }
    }

    @Override
    public void setResponseCallBack(BaseAmsSocketConnectionCallback callBack) {
        super.setResponseCallBack(callBack);
        if (mLocalBroadcastReceiver == null) {
            mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder()
                    .addAction(MessagingEventSubscriptionManager.Companion.getMESSAGE_EVENT_COMPLETED() + dialogId)
                    .build(new LocalBroadcastReceiver.IOnReceive() {
                        @Override
                        public void onBroadcastReceived(Context context, Intent intent) {
                            mLocalBroadcastReceiver.unregister();
							LPMobileLog.d(TAG,"Got Message Event notification for dialog id: " + dialogId + " conversation ID: " + conversationId + ". Sending callback finished successfully");
                            if (intent.getBooleanExtra(MessagingEventSubscriptionManager.Companion.getSUCCESS(),false)){
                                mResponseCallBack.onTaskSuccess();
                            }else{
                                mResponseCallBack.onTaskError(SocketTaskType.QUERY_MESSAGES, new Exception(intent.getStringExtra(MessagingEventSubscriptionManager.Companion.getERROR_MESSAGE())));
                            }
                        }
                    });
        }
        mLocalBroadcastReceiver.register();
    }


}
