package com.liveperson.messaging.commands;

import android.support.annotation.NonNull;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;

import org.json.JSONObject;

/**
 * Created by Maayan on 01/25/17.
 * <p/>
 * This command derives from ResendMessageRequest and implement the sendMessage() method.
 * It differs from the ResendMessageRequest that it needs to parse the JSON that represent the message we are sending
 * when we have a URL message
 */
public class ResendURLMessageCommand extends ResendMessageCommand {

	private static final String TAG = ResendURLMessageCommand.class.getCanonicalName();
	private static final String KEY_JSON_HEADER = "message_with_url";
	private static final String KEY_JSON_TAG_MESSAGE = "original_message";

	public ResendURLMessageCommand(Messaging controller, String eventId, String targetId, String brandId, MaskedMessage message) {
		super(controller, eventId, targetId, brandId, message);
	}

	@NonNull
	@Override
	protected SendMessageRequest createMessageRequest(Messaging mController, String mEventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
		SendMessageRequest sendMessageRequest = new SendMessageRequest(mController, mEventId, mTargetId, mBrandId, dialogId, conversationId);
		sendMessageRequest.setMessageContent(getMessage(mMessage.getServerMessage()));
		return sendMessageRequest;
	}

	/**
	 * getMessage - extract the original message from the JSON message we saved in the DB
	 * @param text
	 * @return - the original message that was sent
	 */
	private String getMessage(String text) {
		JSONObject object;
		try {
			object = new JSONObject(text);
			JSONObject messageWithUrl = object.getJSONObject(KEY_JSON_HEADER);
			return messageWithUrl.getString(KEY_JSON_TAG_MESSAGE);

		} catch (Exception e) {
			LPMobileLog.e(TAG," cannot parse json");
		}
		return text;
	}
}
