package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.Dialog;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task for fetching from DataBase
 */
public class DataBaseTask extends BaseAmsAccountConnectionTask {

    private static final String TAG =  "DataBaseTask";
    private final AmsUsers mAmsUsers;
    private final AmsConversations mAmsConversations;
    private final AmsDialogs mAmsDialogs;

    public DataBaseTask(AmsUsers amsUsers, AmsConversations amsConversations, AmsDialogs amsDialogs, AmsMessages amsMessages) {
        mAmsUsers = amsUsers;
        mAmsConversations = amsConversations;
        mAmsDialogs = amsDialogs;
        AmsMessages mAmsMessages = amsMessages;
    }

    @Override
    public void execute() {
        LPMobileLog.d(TAG, "Running Database loading task...");
		AmsConnectionAnalytics.databaseTaskStart();

        DataBaseExecutor.execute(new Runnable() {
            @Override
            public void run() {
                mAmsUsers.loadConsumerForBrand(mBrandId);
                mAmsConversations.loadOpenConversationForBrand(mBrandId);
                mAmsDialogs.loadOpenDialogsForBrand(mBrandId);
                Dialog dialog = mAmsDialogs.getActiveDialog();
                if (dialog != null){
                    mAmsUsers.loadProfile(dialog.getAssignedAgentId());
                }

                AmsConnectionAnalytics.databaseTaskEnd();
                mCallback.onTaskSuccess();
            }
        });
    }

    @Override
    public String getName() {
        return TAG;
    }
}