package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.request.message.FilePublishMessage;
import com.liveperson.messaging.Messaging;

/**
 * A request to send message
 */
public class SendFileRequest extends SendMessageRequest {

    private static final String TAG = SendFileRequest.class.getSimpleName();

    /**
	 * This constructor creates a SendMessageRequest with the next requestID (auto incremented)
	 *  @param brandId
	 * @param eventId
     * @param dialogId
     */
    public SendFileRequest(Messaging controller, String eventId, String targetId, String brandId, String dialogId, String conversationId) {
        super(controller, eventId, targetId, brandId, dialogId, conversationId);
        setContentType(ContentType.hosted_file);
    }

    /**
     * Set the image details that need to be sent
     * @param caption
     * @param relativePath
     * @param fileType
     * @param preview
     */
    public void setFileContent(String caption, String relativePath, String fileType, String preview){
        mMessage = new FilePublishMessage(caption, relativePath, fileType, preview);
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }


}