package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Button element. Holds a title property
 */
public class ButtonElement extends ActionableElement {

	private ElementStyle mStyle;

	public static final String TAG = ButtonElement.class.getSimpleName();

	/**
	 * The title of the button
	 */
	private String mTitle;

	public ButtonElement() {
		super(ElementType.BUTTON);
	}


	/**
	 * This sets title of the button from the given json.
	 * @param jsonObject
	 * @throws JSONException
	 */
	public ButtonElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);
		mTitle = (String) jsonObject.get(ElementType.TITLE);
		JSONObject style = jsonObject.optJSONObject(ElementType.STYLE); //Optional
		mStyle = new ElementStyle(style);


/*	Action was changed to be optional on Button (to align to other clients that didn't do it correctly). This code is left commented here in case someone will change their mind

		// Action is mandatory in ButtonElement. If missing throw exception
		if (getActions() == null || getActions().isEmpty()) {
			LPMobileLog.w(TAG, this.getClass().getSimpleName() + ": Action is missing, cannot construct ButtonElement");
			throw new JSONException("Action cannot be parsed");
		}
*/


	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + " - " + mTitle + "\n");

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	public String getTitle() {
		return mTitle;
	}

	public void setTitle(String title) {
		mTitle = title;
	}

	public ElementStyle getStyle() {
		return mStyle;
	}
}
