/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.events;

import android.text.TextUtils;
import com.liveperson.api.exception.BadConversationException;
import com.liveperson.api.response.AbstractResponse;
import com.liveperson.api.response.model.Change;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.network.socket.ExConversationChangeNotificationResponseHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExConversationChangeNotification
extends AbstractResponse<Body> {
    public static final String CONVERSATION_CHANGE_NOTIFICATION_TYPE = "cqm.ExConversationChangeNotification";
    public Body notificationBody;

    public ExConversationChangeNotification(JSONObject obj) throws JSONException {
        super(obj);
        this.notificationBody = new Body(obj.getJSONObject("body"));
    }

    public static String getType() {
        return CONVERSATION_CHANGE_NOTIFICATION_TYPE;
    }

    @Override
    public Body getBody() {
        return this.notificationBody;
    }

    public static BaseResponseHandler getResponseHandler(Messaging messaging) {
        return new ExConversationChangeNotificationResponseHandler(messaging);
    }

    public static class Body {
        private String subscriptionId;
        private Change[] changes;

        public Body(JSONObject obj) throws JSONException {
            this.subscriptionId = obj.optString("subscriptionId");
            if (TextUtils.isEmpty((CharSequence)this.subscriptionId)) {
                throw new JSONException("no subscription id");
            }
            JSONArray changesArr = obj.optJSONArray("changes");
            if (changesArr == null) {
                changesArr = new JSONArray();
            }
            this.changes = new Change[changesArr.length()];
            for (int i = 0; i < this.changes.length; ++i) {
                try {
                    this.changes[i] = new Change(changesArr.getJSONObject(i));
                    continue;
                }
                catch (BadConversationException e) {
                    LPMobileLog.e((String)ExConversationChangeNotification.CONVERSATION_CHANGE_NOTIFICATION_TYPE, (String)e.getMessage());
                }
            }
        }

        public String getSubscriptionId() {
            return this.subscriptionId;
        }

        public Change[] getChanges() {
            return this.changes;
        }
    }
}

