/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.text.TextUtils;
import com.liveperson.infra.log.LPMobileLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class Participants {
    public String[] CONSUMER = new String[0];
    public String[] ASSIGNED_AGENT = new String[0];
    public String[] MANAGER = new String[0];
    public String[] READER = new String[0];
    public String[] CONTROLLER = new String[0];
    public String[] AGENTS = new String[0];
    public String[] ALL_AGENTS = new String[0];
    private String[] OTHER_AGENTS = new String[0];

    public void add(ArrayList<String> id, ParticipantRole role) {
        this.add(id.toArray(new String[0]), role);
    }

    public void add(String[] id, ParticipantRole role) {
        switch (role) {
            case READER: {
                this.READER = id;
                break;
            }
            case MANAGER: {
                this.MANAGER = id;
                break;
            }
            case CONSUMER: {
                this.CONSUMER = id;
                break;
            }
            case CONTROLLER: {
                this.CONTROLLER = id;
                break;
            }
            case ASSIGNED_AGENT: {
                this.ASSIGNED_AGENT = id;
                break;
            }
            case AGENT: {
                this.AGENTS = id;
            }
        }
        this.mergeAgents();
    }

    private void mergeAgents() {
        this.OTHER_AGENTS = new String[this.MANAGER.length + this.AGENTS.length + this.READER.length + this.CONTROLLER.length];
        System.arraycopy(this.MANAGER, 0, this.OTHER_AGENTS, 0, this.MANAGER.length);
        System.arraycopy(this.AGENTS, 0, this.OTHER_AGENTS, this.MANAGER.length, this.AGENTS.length);
        System.arraycopy(this.READER, 0, this.OTHER_AGENTS, this.MANAGER.length + this.AGENTS.length, this.READER.length);
        System.arraycopy(this.CONTROLLER, 0, this.OTHER_AGENTS, this.MANAGER.length + this.AGENTS.length + this.READER.length, this.CONTROLLER.length);
        this.ALL_AGENTS = new String[this.ASSIGNED_AGENT.length + this.OTHER_AGENTS.length];
        System.arraycopy(this.ASSIGNED_AGENT, 0, this.ALL_AGENTS, 0, this.ASSIGNED_AGENT.length);
        System.arraycopy(this.OTHER_AGENTS, 0, this.ALL_AGENTS, this.ASSIGNED_AGENT.length, this.OTHER_AGENTS.length);
    }

    public String[] extractAllParticipantsIds() {
        HashSet<String> result = new HashSet<String>();
        ArrayList<String[]> idsHolders = new ArrayList<String[]>();
        idsHolders.add(this.CONSUMER);
        idsHolders.add(this.ASSIGNED_AGENT);
        idsHolders.add(this.AGENTS);
        idsHolders.add(this.MANAGER);
        idsHolders.add(this.READER);
        idsHolders.add(this.CONTROLLER);
        idsHolders.add(this.ALL_AGENTS);
        idsHolders.add(this.OTHER_AGENTS);
        Iterator iterator = idsHolders.iterator();
        while (iterator.hasNext()) {
            String[] idsHolder;
            for (String id : idsHolder = (String[])iterator.next()) {
                if (TextUtils.isEmpty((CharSequence)id)) continue;
                result.add(id);
            }
        }
        return result.toArray(new String[0]);
    }

    public static enum ParticipantRole {
        CONSUMER("CONSUMER"),
        ASSIGNED_AGENT("ASSIGNED_AGENT"),
        AGENT("AGENT"),
        MANAGER("MANAGER"),
        READER("READER"),
        CONTROLLER("CONTROLLER");

        private static final String TAG;
        String participantType;

        private ParticipantRole(String type) {
            this.participantType = type;
        }

        public static ParticipantRole getParticipantRole(String role) {
            for (ParticipantRole pr : ParticipantRole.values()) {
                if (!pr.participantType.equalsIgnoreCase(role)) continue;
                return pr;
            }
            LPMobileLog.e((String)TAG, (String)("Unknown 'ParticipantRole' named: " + role));
            return null;
        }

        public static ParticipantRole parse(String participantRoleString) {
            ParticipantRole result = null;
            try {
                result = ParticipantRole.valueOf(participantRoleString);
            }
            catch (IllegalArgumentException e) {
                ParticipantRole[] values;
                for (ParticipantRole value : values = ParticipantRole.values()) {
                    if (!value.name().equalsIgnoreCase(participantRoleString)) continue;
                    result = value;
                    break;
                }
            }
            return result;
        }

        static {
            TAG = ParticipantRole.class.getSimpleName();
        }
    }
}

