/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.types;

import android.text.TextUtils;
import com.liveperson.infra.log.LPMobileLog;

public enum CloseReason {
    CONSUMER,
    AGENT,
    SYSTEM,
    TIMEOUT;

    private static final String TAG;

    public static CloseReason parse(int ordinal) {
        CloseReason result = SYSTEM;
        CloseReason[] values = CloseReason.values();
        if (ordinal < values.length) {
            result = values[ordinal];
        }
        return result;
    }

    public static CloseReason parse(String closeReasonString) {
        CloseReason result = SYSTEM;
        if (TextUtils.isEmpty((CharSequence)closeReasonString)) {
            return result;
        }
        try {
            result = CloseReason.valueOf(closeReasonString);
        }
        catch (Exception e) {
            CloseReason[] values;
            LPMobileLog.e((String)TAG, (String)("Failed to parse CloseReason from string: " + closeReasonString));
            for (CloseReason closeReason : values = CloseReason.values()) {
                if (!closeReason.name().equalsIgnoreCase(closeReasonString)) continue;
                result = closeReason;
                break;
            }
        }
        return result;
    }

    static {
        TAG = CloseReason.class.getSimpleName();
    }
}

