/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging;

import com.liveperson.api.LivePersonCallback;
import com.liveperson.api.LivePersonIntents;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.sdk.LPConversationData;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.Infra;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.model.AgentData;

public class LivePersonEventsProxy
implements LivePersonCallback {
    private LivePersonCallback mCallback = new LivePersonCallback.NullLivePersonCallback();

    LivePersonEventsProxy() {
    }

    public void setCallback(LivePersonCallback mCallback) {
        this.mCallback = mCallback;
    }

    public void removeCallback() {
        this.mCallback = new LivePersonCallback.NullLivePersonCallback();
    }

    @Override
    public void onError(final TaskType type, final String message) {
        Infra.instance.getApplicationHandler().post(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onError(type, message);
                LivePersonIntents.sendOnErrorIntent(Infra.instance.getApplicationContext(), type, message);
            }
        });
    }

    @Override
    public void onTokenExpired() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onTokenExpired();
                LivePersonIntents.sendOnTokenExpired(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onUnauthenticatedUserExpired() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onUnauthenticatedUserExpired();
                LivePersonIntents.sendOnUserExpired(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onConversationStarted(final LPConversationData convData) {
        Infra.instance.getApplicationHandler().post(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onConversationStarted();
                LivePersonEventsProxy.this.mCallback.onConversationStarted(convData);
                LivePersonIntents.sendOnConversationStarted(Infra.instance.getApplicationContext(), convData);
            }
        });
    }

    @Override
    @Deprecated
    public void onConversationStarted() {
        this.mCallback.onConversationStarted();
    }

    @Override
    public void onConversationResolved(final LPConversationData convData) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onConversationResolved();
                LivePersonEventsProxy.this.mCallback.onConversationResolved(convData.getCloseReason());
                LivePersonEventsProxy.this.mCallback.onConversationResolved(convData);
                LivePersonIntents.sendOnConversationResolved(Infra.instance.getApplicationContext(), convData);
            }
        });
    }

    @Override
    @Deprecated
    public void onConversationResolved() {
        this.mCallback.onConversationResolved();
    }

    @Override
    @Deprecated
    public void onConversationResolved(CloseReason reason) {
        this.mCallback.onConversationResolved(reason);
    }

    @Override
    public void onConversationFragmentClosed() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onConversationFragmentClosed();
                LivePersonIntents.sendOnConversationFragmentClosed(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onConnectionChanged(final boolean isConnected) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onConnectionChanged(isConnected);
                LivePersonIntents.sendOnConnectionChanged(Infra.instance.getApplicationContext(), isConnected);
            }
        });
    }

    @Override
    public void onAgentTyping(final boolean isTyping) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onAgentTyping(isTyping);
                LivePersonIntents.sendOnAgentTyping(Infra.instance.getApplicationContext(), isTyping);
            }
        });
    }

    @Override
    public void onAgentDetailsChanged(final AgentData agentData) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onAgentDetailsChanged(agentData);
                LivePersonIntents.sendOnAgentDetailsChanged(Infra.instance.getApplicationContext(), agentData);
            }
        });
    }

    @Override
    public void onCsatLaunched() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onCsatLaunched();
                LivePersonIntents.sendOnCsatLaunched(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onCsatDismissed() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onCsatDismissed();
                LivePersonIntents.sendOnCsatDismissed(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onCsatSubmitted(final String conversationId) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onCsatSubmitted(conversationId);
                LivePersonIntents.sendOnCsatSubmitted(Infra.instance.getApplicationContext(), conversationId);
            }
        });
    }

    @Override
    public void onCsatSkipped() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onCsatSkipped();
                LivePersonIntents.sendOnCsatSkipped(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onConversationMarkedAsUrgent() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onConversationMarkedAsUrgent();
                LivePersonIntents.sendOnConversationMarkedAsUrgent(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onConversationMarkedAsNormal() {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onConversationMarkedAsNormal();
                LivePersonIntents.sendOnConversationMarkedAsNormal(Infra.instance.getApplicationContext());
            }
        });
    }

    @Override
    public void onOfflineHoursChanges(final boolean isOfflineHoursOn) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onOfflineHoursChanges(isOfflineHoursOn);
                LivePersonIntents.sendOnOfflineHoursChanges(Infra.instance.getApplicationContext(), isOfflineHoursOn);
            }
        });
    }

    @Override
    public void onAgentAvatarTapped(final AgentData agentData) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onAgentAvatarTapped(agentData);
                LivePersonIntents.sendOnAgentAvatarTapped(Infra.instance.getApplicationContext(), agentData);
            }
        });
    }

    @Override
    public void onUserDeniedPermission(final PermissionType permissionType, final boolean doNotShowAgainMarked) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onUserDeniedPermission(permissionType, doNotShowAgainMarked);
                LivePersonIntents.sendOnUserDeniedPermission(Infra.instance.getApplicationContext(), permissionType, doNotShowAgainMarked);
            }
        });
    }

    @Override
    public void onUserActionOnPreventedPermission(final PermissionType permissionType) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onUserActionOnPreventedPermission(permissionType);
                LivePersonIntents.sendOnUserActionOnPreventedPermission(Infra.instance.getApplicationContext(), permissionType);
            }
        });
    }

    @Override
    public void onStructuredContentLinkClicked(final String uri) {
        Infra.instance.postOnMainThread(new Runnable(){

            @Override
            public void run() {
                LivePersonEventsProxy.this.mCallback.onStructuredContentLinkClicked(uri);
                LivePersonIntents.sendOnStructuredContentLinkClicked(Infra.instance.getApplicationContext(), uri);
            }
        });
    }
}

