/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.SendVoiceCommand;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendVoiceCommand
extends SendVoiceCommand {
    public static final String TAG = "ReSendVoiceCommand";
    private long mFileRowId;
    private long mOriginalMessageTime;

    public ReSendVoiceCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, long fileRowId, long originalMessageTime, String previewContentType, String eventId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message, previewContentType);
        this.mFileRowId = fileRowId;
        this.mOriginalMessageTime = originalMessageTime;
        this.mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message) {
        this.mController.amsMessages.updateMessageState(this.mEventId, this.mTargetId, conversationId, MessagingChatMessage.MessageState.QUEUED);
        this.mController.amsMessages.getRowIdByEventId(this.mEventId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Long>(){

            public void onResult(Long data) {
                ReSendVoiceCommand.this.mMessageRowId = data;
                if (ReSendVoiceCommand.this.mCallback != null) {
                    ReSendVoiceCommand.this.mCallback.onFileAddedToDB(ReSendVoiceCommand.this.mMessageRowId, ReSendVoiceCommand.this.mFileRowId);
                }
            }
        }).execute();
    }

    @Override
    protected long getMessageTime() {
        return this.mOriginalMessageTime;
    }
}

