/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.support.annotation.Nullable;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.LPAuthenticationParams;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.requests.PushRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;
import java.util.List;

public class RegisterPusherCommand
implements Command {
    private static final String TAG = RegisterPusherCommand.class.getSimpleName();
    private static final String PUSHER_URL = "https://%s/api/account/%s/device/register";
    private final Messaging mController;
    private final LPAuthenticationParams mLpAuthParams;
    private String mBrandId;
    private String mToken;
    private String mAppId;
    @Nullable
    private ICallback<Void, Exception> mRegistrationCompletedCallback;

    public RegisterPusherCommand(Messaging messagingController, String brandId, String appId, String token, LPAuthenticationParams lpAuthParams, ICallback<Void, Exception> registrationCompletedCallback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mToken = token;
        this.mAppId = appId;
        this.mLpAuthParams = lpAuthParams;
        this.mRegistrationCompletedCallback = registrationCompletedCallback;
    }

    public void execute() {
        LPMobileLog.i((String)TAG, (String)("execute with token " + this.mToken));
        boolean isExecuting = new SynchronizedAuthenticationCompletedCallback(this.mController.mAccountsController, this.mBrandId, new ICallback<Void, Exception>(){

            public void onSuccess(Void value) {
                List<String> certificates = ((RegisterPusherCommand)RegisterPusherCommand.this).mController.mAccountsController.getCertificatePinningKeys(RegisterPusherCommand.this.mBrandId);
                String pusherDomain = ((RegisterPusherCommand)RegisterPusherCommand.this).mController.mAccountsController.getServiceUrl(RegisterPusherCommand.this.mBrandId, "pusher");
                String pusherURL = String.format(RegisterPusherCommand.PUSHER_URL, pusherDomain, RegisterPusherCommand.this.mBrandId);
                LPMobileLog.i((String)TAG, (String)("Running register pusher with token " + RegisterPusherCommand.this.mToken));
                new PushRequest(pusherURL, ((RegisterPusherCommand)RegisterPusherCommand.this).mController.amsUsers.getConsumerId(RegisterPusherCommand.this.mBrandId), RegisterPusherCommand.this.mAppId, RegisterPusherCommand.this.mToken, ((RegisterPusherCommand)RegisterPusherCommand.this).mController.mAccountsController.getToken(RegisterPusherCommand.this.mBrandId), certificates).setCallback(RegisterPusherCommand.this.mRegistrationCompletedCallback).execute();
            }

            public void onError(Exception exception) {
                if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                    RegisterPusherCommand.this.mRegistrationCompletedCallback.onError((Throwable)exception);
                }
            }
        }).executeWithReturnValue();
        if (!isExecuting && this.mLpAuthParams != null) {
            this.mController.connect(this.mBrandId, this.mLpAuthParams, null, true, false);
        }
    }
}

