/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.api.response.types.CloseReason;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.ResolveConversationRequest;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class ResolveConversationCommand
implements Command {
    private static final String TAG = ResolveConversationCommand.class.getSimpleName();
    private final AmsConversations mAmsConversations;
    private boolean mOfflineMode = false;
    private String mTargetId;
    private String mSocketUrl;
    private ICallback<String, Throwable> callback;

    public ResolveConversationCommand(AmsConversations amsConversations, String targetId, @Nullable String socketUrl) {
        this.mAmsConversations = amsConversations;
        this.mSocketUrl = socketUrl;
        this.mTargetId = targetId;
    }

    public void setOfflineMode(boolean offline) {
        this.mOfflineMode = offline;
    }

    public void execute() {
        if (!this.mAmsConversations.isConversationActive(this.mTargetId)) {
            LPMobileLog.w((String)TAG, (String)"No open conversation found. aborting resolve conversation command");
            return;
        }
        Conversation conversation = this.mAmsConversations.getConversation(this.mTargetId);
        if (this.mOfflineMode) {
            final ConversationData conversationData = new ConversationData(this.mTargetId, conversation);
            conversationData.closeReason = CloseReason.CONSUMER;
            conversationData.endTs = System.currentTimeMillis();
            final ArrayList dialogs = new ArrayList();
            this.mAmsConversations.updateClosedConversation(conversationData, false).setPreQueryOnBackground(new Runnable(){

                @Override
                public void run() {
                    ArrayList _dialogs = (ArrayList)MessagingFactory.getInstance().getController().amsDialogs.queryDialogsByConversationId(conversationData.conversationId).executeSynchronously();
                    dialogs.addAll(_dialogs);
                    conversationData.setDialogs(dialogs);
                }
            }).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Conversation>(){

                public void onResult(Conversation conversationResult) {
                    if (conversationResult != null) {
                        for (Dialog dialog : dialogs) {
                            if (!dialog.isOpen()) continue;
                            Dialog dialogResult = (Dialog)MessagingFactory.getInstance().getController().amsDialogs.updateClosedDialog(conversationData, dialog, false).executeSynchronously();
                            LPMobileLog.d((String)TAG, (String)("Updating closed dialog. " + dialogResult.getDialogId()));
                        }
                    }
                    if (ResolveConversationCommand.this.callback != null) {
                        ResolveConversationCommand.this.callback.onSuccess((Object)"");
                    }
                }
            }).execute();
        } else {
            ResolveConversationRequest resolveConversationRequest = new ResolveConversationRequest(this.mSocketUrl, conversation.getConversationId());
            resolveConversationRequest.setResponseCallBack(this.callback);
            SocketManager.getInstance().send((BaseSocketRequest)resolveConversationRequest);
        }
    }

    public void setCallback(ICallback<String, Throwable> callback) {
        this.callback = callback;
    }
}

