/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.text.TextUtils;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.Command;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.SynchronizedAmsConnectionCallback;
import com.liveperson.messaging.model.UserProfileBundle;
import com.liveperson.messaging.network.socket.requests.SetUsersProfileRequest;

public class SendSetUserProfileCommand
implements Command {
    public static final String TAG = SetUsersProfileRequest.class.getSimpleName();
    private final Messaging mController;
    private String mBrandId;
    private UserProfileBundle mUserProfileBundle;

    public SendSetUserProfileCommand(Messaging messagingController, String brandId, UserProfileBundle userProfileBundle) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mUserProfileBundle = userProfileBundle;
    }

    public void execute() {
        LPMobileLog.i((String)TAG, (String)"Running SetUserProfile request...");
        new SynchronizedAmsConnectionCallback(this.mController.mConnectionController, this.mBrandId, new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)SendSetUserProfileCommand.this.mBrandId)) {
                    LPMobileLog.e((String)TAG, (String)"execute: BrandId is empty. Cannot proceed with set user profile");
                    return;
                }
                String consumerId = ((SendSetUserProfileCommand)SendSetUserProfileCommand.this).mController.amsUsers.getConsumerId(SendSetUserProfileCommand.this.mBrandId);
                LPMobileLog.d((String)TAG, (String)("consumer id " + consumerId + "\nFirst name " + SendSetUserProfileCommand.this.mUserProfileBundle.getFirstName() + "\nLast name " + SendSetUserProfileCommand.this.mUserProfileBundle.getLastName() + "\nPhone number " + SendSetUserProfileCommand.this.mUserProfileBundle.getPhoneNumber() + "\nNick name " + SendSetUserProfileCommand.this.mUserProfileBundle.getNickname() + "\nAvatar URL " + SendSetUserProfileCommand.this.mUserProfileBundle.getAvatarUrl()));
                MessagingUserProfile msgUserProfile = new MessagingUserProfile(SendSetUserProfileCommand.this.mUserProfileBundle.getFirstName(), SendSetUserProfileCommand.this.mUserProfileBundle.getLastName(), UserProfile.UserType.CONSUMER);
                msgUserProfile.setAvatarUrl(SendSetUserProfileCommand.this.mUserProfileBundle.getAvatarUrl());
                msgUserProfile.setNickname(SendSetUserProfileCommand.this.mUserProfileBundle.getNickname());
                msgUserProfile.setDescription(SendSetUserProfileCommand.this.mUserProfileBundle.getPhoneNumber());
                msgUserProfile.setPrivateData(new UserProfile.PrivateData("", ""));
                msgUserProfile.setMobileNumber(SendSetUserProfileCommand.this.mUserProfileBundle.getPhoneNumber());
                msgUserProfile.setOriginatorID(consumerId);
                SetUsersProfileRequest setUsersProfileRequest = new SetUsersProfileRequest(((SendSetUserProfileCommand)SendSetUserProfileCommand.this).mController.amsUsers, ((SendSetUserProfileCommand)SendSetUserProfileCommand.this).mController.mAccountsController.getConnectionUrl(SendSetUserProfileCommand.this.mBrandId), SendSetUserProfileCommand.this.mBrandId, msgUserProfile);
                SocketManager.getInstance().send((BaseSocketRequest)setUsersProfileRequest);
            }
        }).execute();
    }
}

