/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.content.Context;
import com.liveperson.infra.configuration.ConfigurableResource;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollectSDKConfigurationDataTask
extends BaseAmsAccountConnectionTask {
    public static final String TAG = "CollectConfigurationDataTask";
    private Context mContext;
    private long mLastTimeErrorSent;
    private static final long MIN_DAYS_BEFORE_RESENDING_DATA = 2592000000L;

    public CollectSDKConfigurationDataTask(Context context) {
        this.mContext = context;
    }

    public boolean isShouldExecute() {
        long currentTimeInMillis = System.currentTimeMillis();
        long mLastDatePublish = PreferenceManager.getInstance().getLongValue("configuration_data_publish_date_preference_key", "appLevelPreferences", -1L);
        LPMobileLog.d((String)TAG, (String)("Android configuration currentTimeInMillis: " + currentTimeInMillis));
        LPMobileLog.d((String)TAG, (String)("Android configuration mLastDatePublish: " + mLastDatePublish));
        return mLastDatePublish == -1L || mLastDatePublish - currentTimeInMillis >= 2592000000L;
    }

    public void execute() {
        if (!this.isShouldExecute()) {
            LPMobileLog.d((String)TAG, (String)"Android configuration should not execute");
            this.mCallback.onTaskSuccess();
            return;
        }
        AmsConnectionAnalytics.collectSDKConfigurationDataTaskStart();
        new Thread(new Runnable(){

            @Override
            public void run() {
                HashMap booleans = Configuration.scanXmlIdsAndNames(R.bool.class);
                HashMap colors = Configuration.scanXmlIdsAndNames(R.color.class);
                HashMap integers = Configuration.scanXmlIdsAndNames(R.integer.class);
                HashMap dimensions = Configuration.scanXmlIdsAndNames(R.dimen.class);
                StringBuilder sb = new StringBuilder();
                sb.append("SDKConfiguration: ");
                sb.append((CharSequence)CollectSDKConfigurationDataTask.this.printList(booleans, ConfigurableResource.ResourceType.Boolean));
                sb.append((CharSequence)CollectSDKConfigurationDataTask.this.printList(integers, ConfigurableResource.ResourceType.Integer));
                sb.append((CharSequence)CollectSDKConfigurationDataTask.this.printList(colors, ConfigurableResource.ResourceType.Color));
                sb.append((CharSequence)CollectSDKConfigurationDataTask.this.printList(dimensions, ConfigurableResource.ResourceType.Dimension));
                LPMobileLog.d((String)CollectSDKConfigurationDataTask.TAG, (String)("Android configuration is: " + sb.toString()));
                AmsConnectionAnalytics.collectSDKConfigurationDataTaskEnd();
                PreferenceManager.getInstance().setLongValue("configuration_data_publish_date_preference_key", "appLevelPreferences", System.currentTimeMillis());
                LPMobileLog.d((String)CollectSDKConfigurationDataTask.TAG, (String)("Android configuration setLongValue: " + System.currentTimeMillis()));
                CollectSDKConfigurationDataTask.this.mCallback.onTaskSuccess();
            }
        }).start();
    }

    private StringBuilder printList(HashMap<Integer, String> resources, ConfigurableResource.ResourceType resourceType) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Integer, String>> resourceEntries = resources.entrySet();
        for (Map.Entry<Integer, String> resourceEntry : resourceEntries) {
            String value;
            String resourceName = resourceEntry.getValue();
            switch (resourceType) {
                case Integer: {
                    value = String.valueOf(Configuration.getInteger((int)resourceEntry.getKey()));
                    break;
                }
                case Dimension: {
                    value = String.valueOf(Configuration.getDimension((int)resourceEntry.getKey()));
                    break;
                }
                case Boolean: {
                    value = String.valueOf(Configuration.getBoolean((int)resourceEntry.getKey()));
                    break;
                }
                case Color: {
                    int color2 = Configuration.getColor((int)resourceEntry.getKey());
                    value = String.valueOf(color2);
                    break;
                }
                default: {
                    value = "unknown value";
                }
            }
            sb.append(" configurationId= ").append(resourceName).append(" value= ").append(value).append("\n");
        }
        return sb;
    }

    @Override
    public String getName() {
        return TAG;
    }
}

