/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.Dialog;

public class DataBaseTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "DataBaseTask";
    private final AmsUsers mAmsUsers;
    private final AmsConversations mAmsConversations;
    private final AmsDialogs mAmsDialogs;

    public DataBaseTask(AmsUsers amsUsers, AmsConversations amsConversations, AmsDialogs amsDialogs, AmsMessages amsMessages) {
        this.mAmsUsers = amsUsers;
        this.mAmsConversations = amsConversations;
        this.mAmsDialogs = amsDialogs;
        AmsMessages mAmsMessages = amsMessages;
    }

    public void execute() {
        LPMobileLog.d((String)TAG, (String)"Running Database loading task...");
        AmsConnectionAnalytics.databaseTaskStart();
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                DataBaseTask.this.mAmsUsers.loadConsumerForBrand(DataBaseTask.this.mBrandId);
                DataBaseTask.this.mAmsConversations.loadOpenConversationForBrand(DataBaseTask.this.mBrandId);
                DataBaseTask.this.mAmsDialogs.loadOpenDialogsForBrand(DataBaseTask.this.mBrandId);
                Dialog dialog = DataBaseTask.this.mAmsDialogs.getActiveDialog();
                if (dialog != null) {
                    DataBaseTask.this.mAmsUsers.loadProfile(dialog.getAssignedAgentId());
                }
                AmsConnectionAnalytics.databaseTaskEnd();
                DataBaseTask.this.mCallback.onTaskSuccess();
            }
        });
    }

    @Override
    public String getName() {
        return TAG;
    }
}

