/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.SynchronizedAmsConnectionUpdateCallback;

public class HandlePendingMessagesTask
extends BaseAmsSocketConnectionTask {
    private AmsMessages amsMessages;
    private AmsConversations amsConversations;
    private AmsDialogs amsDialogs;
    private ConnectionsController mConnectionController;
    private static final String TAG = "HandlePendingMessagesTask";

    public HandlePendingMessagesTask(AmsMessages amsMessages, AmsConversations amsConversations, AmsDialogs amsDialogs, ConnectionsController connectionController) {
        this.amsMessages = amsMessages;
        this.amsConversations = amsConversations;
        this.amsDialogs = amsDialogs;
        this.mConnectionController = connectionController;
    }

    public void execute() {
        LPMobileLog.d((String)TAG, (String)"Running mark all pending messages as failed task...");
        new SynchronizedAmsConnectionUpdateCallback(this.mConnectionController, this.mBrandId, new Runnable(){

            @Override
            public void run() {
                HandlePendingMessagesTask.this.amsMessages.resendAllPendingMessages(HandlePendingMessagesTask.this.mBrandId);
            }
        }).execute();
        this.amsConversations.markAllPendingConversationsAsFailed(this.mBrandId);
        this.amsDialogs.markPendingDialogsAsFailed(this.mBrandId);
        this.mCallback.onTaskSuccess();
    }
}

