/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.model.SocketConnectionParams;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.ClientProperties;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AmsConnection;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.List;

public class OpenSocketTask
extends BaseAmsAccountConnectionTask {
    public static final String AUTHORIZATION = "Authorization";
    private static final String TAG = "OpenSocketTask";
    private static final int SOCKET_TIMEOUT = 30000;
    public static final String CLIENT_PROPERTIES = "Client-Properties";
    public static final String JWT = "jwt %1$s";
    private static final String USER_AGENT = "User-Agent";
    private static final String ANDROID = "ANDROID";
    private final AccountsController mAccountsController;
    private final ConnectionsController mConnectionController;

    public OpenSocketTask(AccountsController accountsController, ConnectionsController connectionController) {
        this.mAccountsController = accountsController;
        this.mConnectionController = connectionController;
    }

    @Override
    public boolean requireSDKinForeground() {
        return true;
    }

    public void execute() {
        AmsConnectionAnalytics.openSocketTaskStart();
        String connectionUrl = this.mAccountsController.getConnectionUrl(this.mBrandId);
        String connectionUrlForLogs = this.mAccountsController.getConnectionUrlForLogs(this.mBrandId);
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        String token = this.mAccountsController.getToken(this.mBrandId);
        ClientProperties clientProperties = this.mAccountsController.getClientProperties();
        LPMobileLog.d((String)TAG, (String)("Running open socket task. url = " + connectionUrl));
        LPMobileLog.i((String)TAG, (String)("Running open socket task. url = " + connectionUrlForLogs));
        AmsConnection.AmsSocketState socketState = this.mConnectionController.registerSocket(this.mBrandId);
        socketState.setCallback(this.mCallback);
        SocketConnectionParams connectionParams = new SocketConnectionParams(connectionUrl, 30000, certificates);
        connectionParams.addHeader(AUTHORIZATION, String.format(JWT, token));
        connectionParams.addHeader(CLIENT_PROPERTIES, clientProperties.getJsonString());
        connectionParams.addHeader(USER_AGENT, ANDROID);
        LPMobileLog.d((String)TAG, (String)("execute: connectionParams headers: " + connectionParams.getHeaders()));
        SocketManager.getInstance().connect(connectionParams);
    }

    @Override
    public String getName() {
        return TAG;
    }
}

