/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.api.request.ReqBody;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.network.socket.requests.UnSubscribeExConversationsRequest;

public class UnsubscribeExConversationTask
extends BaseAmsSocketConnectionTask {
    public static final String TAG = UnsubscribeExConversationTask.class.getSimpleName();
    protected final Messaging mController;

    public UnsubscribeExConversationTask(Messaging controller) {
        this.mController = controller;
    }

    public void execute() {
        String subscriptionId = this.mController.mConnectionController.getSubscriptionId(this.mBrandId);
        if (subscriptionId == null) {
            LPMobileLog.d((String)TAG, (String)("Cannot find subscriptionId for brand " + this.mBrandId));
            this.mCallback.onTaskSuccess();
            return;
        }
        LPMobileLog.i((String)TAG, (String)"Running UnsubscribeExConversation task...");
        UnSubscribeExConversationsRequest unSubscribeExConversationsRequest = new UnSubscribeExConversationsRequest(this.mController.mAccountsController.getConnectionUrl(this.mBrandId), subscriptionId);
        unSubscribeExConversationsRequest.addCallback((ResponseCallback)new ResponseCallback<ReqBody.StringResp>(){

            public void onSuccess(ReqBody.StringResp data) {
                UnsubscribeExConversationTask.this.mCallback.onTaskSuccess();
            }

            public void onError() {
                UnsubscribeExConversationTask.this.mCallback.onTaskError(SocketTaskType.UN_SUBSCRIBE, new Exception(TAG));
            }
        });
        SocketManager.getInstance().send((BaseSocketRequest)unSubscribeExConversationsRequest);
    }
}

