/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientProperties
implements Clearable {
    private static final String TAG = ClientProperties.class.getSimpleName();
    private static final String APP_ID_PREFERENCE_KEY = "APP_ID_PREFERENCE_KEY";
    private static final String SDK_VERSION_PREFERENCE_KEY = "SDK_VERSION_PREFERENCE_KEY";
    private static final String APP_ID = "appId";
    private static final String DEVICE_FAMILY = "deviceFamily";
    private static final String OS_NAME = "os";
    private static final String IP_ADDRESS = "ipAddress";
    private static final String OS_VERSION = "osVersion";
    private static final String INTEGRATION = "integration";
    private static final String INTEGRATION_VERSION = "integrationVersion";
    private static final String BROWSER = "browser";
    private static final String BROWSER_VERSION = "browserVersion";
    private static final String TIME_ZONE = "timeZone";
    private static final String DEVICE_MANUFACTOR = "deviceManufactor";
    private static final String DEVICE_MODEL = "deviceModel";
    private static final String APP_VERSION = "appVersion";
    private static final String FEATURES = "features";
    private static final String TYPE = "type";
    private static final String TYPE_VALUE = ".ClientProperties";
    private String mAppId;
    private String mSdkVersion;
    private final String ipAddress;
    private JSONObject mJson;

    public ClientProperties(String appId, String appVersion) {
        String _ipAddress;
        try {
            _ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            _ipAddress = "unknown";
            LPMobileLog.e((String)TAG, (String)("Failed to get ip address, unknown host exception: " + e));
        }
        this.ipAddress = _ipAddress;
        this.saveAppId(appId);
        this.saveSDKVersion(appVersion);
        this.createJson();
        LPMobileLog.w((String)TAG, (String)("## DEVICE_FAMILY: " + DeviceFamily.MOBILE.name()));
        LPMobileLog.w((String)TAG, (String)("## OS_NAME: " + OS.ANDROID.name()));
        LPMobileLog.w((String)TAG, (String)("## OS_VERSION: " + String.valueOf(Build.VERSION.SDK_INT)));
        LPMobileLog.w((String)TAG, (String)("## INTEGRATION: " + Integration.MOBILE_SDK.name()));
        LPMobileLog.w((String)TAG, (String)("## OS_VERSION: " + String.valueOf(Build.VERSION.CODENAME)));
    }

    public ClientProperties() {
        this(null, null);
    }

    private void createJson() {
        this.mJson = new JSONObject();
        try {
            this.mJson.put(APP_ID, (Object)this.mAppId);
            this.mJson.put(DEVICE_FAMILY, (Object)DeviceFamily.MOBILE.name());
            this.mJson.put(OS_NAME, (Object)OS.ANDROID.name());
            this.mJson.put(OS_VERSION, (Object)String.valueOf(Build.VERSION.SDK_INT));
            this.mJson.put(INTEGRATION, (Object)Integration.MOBILE_SDK.name());
            this.mJson.put(INTEGRATION_VERSION, (Object)this.mSdkVersion);
            this.mJson.put(TYPE, (Object)TYPE_VALUE);
            JSONArray featuresArray = new JSONArray();
            featuresArray.put((Object)Features.PHOTO_SHARING.name()).put((Object)Features.CO_APP.name()).put((Object)Features.RICH_CONTENT.name()).put((Object)Features.SECURE_FORMS.name()).put((Object)Features.AUTO_MESSAGES.name()).put((Object)Features.QUICK_REPLIES.name()).put((Object)Features.MULTI_DIALOG.name());
            if (Configuration.getBoolean((int)R.bool.enable_file_Sharing)) {
                featuresArray.put((Object)Features.FILE_SHARING.name());
            }
            this.mJson.put(FEATURES, (Object)featuresArray);
            this.mJson.put(TIME_ZONE, (Object)TimeZone.getDefault().getID());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getJsonString() {
        return this.mJson.toString();
    }

    public void addToUriBuilder(Uri.Builder builder) {
        builder.appendQueryParameter(APP_ID, this.mAppId).appendQueryParameter(DEVICE_FAMILY, DeviceFamily.MOBILE.name()).appendQueryParameter(OS_NAME, OS.ANDROID.name()).appendQueryParameter(IP_ADDRESS, this.ipAddress).appendQueryParameter(OS_VERSION, String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter(INTEGRATION, Integration.MOBILE_SDK.name()).appendQueryParameter(INTEGRATION_VERSION, this.mSdkVersion).appendQueryParameter(FEATURES, Features.PHOTO_SHARING.name() + "," + Features.CO_APP.name() + "," + Features.RICH_CONTENT.name() + "," + Features.SECURE_FORMS.name() + "," + Features.AUTO_MESSAGES.name() + "," + Features.QUICK_REPLIES.name() + "," + Features.MULTI_DIALOG.name()).appendQueryParameter(TIME_ZONE, TimeZone.getDefault().getID());
    }

    public void saveAppId(String newAppId) {
        if (TextUtils.isEmpty((CharSequence)newAppId)) {
            this.mAppId = PreferenceManager.getInstance().getStringValue(APP_ID_PREFERENCE_KEY, "appLevelPreferences", "");
        } else {
            this.mAppId = newAppId;
            PreferenceManager.getInstance().setStringValue(APP_ID_PREFERENCE_KEY, "appLevelPreferences", this.mAppId);
        }
    }

    public void saveSDKVersion(String newSdkVersion) {
        if (TextUtils.isEmpty((CharSequence)newSdkVersion)) {
            this.mSdkVersion = PreferenceManager.getInstance().getStringValue(SDK_VERSION_PREFERENCE_KEY, "appLevelPreferences", "");
        } else {
            this.mSdkVersion = newSdkVersion;
            PreferenceManager.getInstance().setStringValue(SDK_VERSION_PREFERENCE_KEY, "appLevelPreferences", this.mSdkVersion);
        }
    }

    public void clear() {
        PreferenceManager.getInstance().remove(APP_ID_PREFERENCE_KEY, "appLevelPreferences");
        PreferenceManager.getInstance().remove(SDK_VERSION_PREFERENCE_KEY, "appLevelPreferences");
    }

    public static enum Features {
        CO_BROWSE,
        CO_APP,
        PHOTO_SHARING,
        SECURE_FORMS,
        RICH_CONTENT,
        AUTO_MESSAGES,
        QUICK_REPLIES,
        MULTI_DIALOG,
        FILE_SHARING;

    }

    private static enum Browser {
        CHROME,
        FIREFOX,
        IE,
        OPERA,
        SAFARI,
        OTHER;

    }

    private static enum Integration {
        WEB_SDK,
        MOBILE_SDK,
        BRAND_SDK;

    }

    private static enum OS {
        WINDOWS,
        LINUX,
        OSX,
        ANDROID,
        IOS,
        OTHER;

    }

    private static enum DeviceFamily {
        MOBILE,
        TABLET,
        PERSONAL_COMPUTER,
        PDA,
        OTHER,
        UNKNOWN;

    }
}

