/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.text.TextUtils;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.EncryptionVersion;
import org.json.JSONException;
import org.json.JSONObject;

public class QuickRepliesMessageHolder {
    public static final String TAG = "QuickRepliesMessageHolder";
    public static String QUICK_REPLIES_SHARED_PREFERENCES_KEY = "quick_replies_shared_preferences_key";
    private static String QUICK_REPLIES_KEY = "quick_replies_key";
    private static String TIMESTAMP_KEY = "timestamp_key";
    private static String ORIGINATOR_ID_KEY = "originator_id_key";
    private static String SEQUENCE_KEY = "sequence_key";
    private static String SHOW_KEY = "show_key";
    private String mQuickRepliesString;
    private String mOriginatorId;
    private int mSequence;
    private long mTimestamp;
    private boolean mShow;
    private String mBrandId;

    public QuickRepliesMessageHolder(String brandId, String quickRepliesString, long timestamp, String originatorId, int sequence, boolean show) {
        this.mQuickRepliesString = quickRepliesString;
        this.mTimestamp = timestamp;
        this.mOriginatorId = originatorId;
        this.mSequence = sequence;
        this.mShow = show;
        this.mBrandId = brandId;
    }

    public static QuickRepliesMessageHolder fromContentEventNotification(String brandId, ContentEventNotification notification) {
        if (TextUtils.isEmpty((CharSequence)notification.event.quickRepliesJsonString)) {
            return null;
        }
        return new QuickRepliesMessageHolder(brandId, notification.event.quickRepliesJsonString, notification.serverTimestamp, notification.originatorId, notification.sequence, true);
    }

    public static QuickRepliesMessageHolder fromJsonString(String brandId, String jsonString) {
        try {
            JSONObject obj = new JSONObject(jsonString);
            return new QuickRepliesMessageHolder(brandId, obj.getString(QUICK_REPLIES_KEY), obj.getLong(TIMESTAMP_KEY), obj.getString(ORIGINATOR_ID_KEY), obj.getInt(SEQUENCE_KEY), obj.getBoolean(SHOW_KEY));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getJsonString() {
        if (this.mQuickRepliesString == null) {
            return "";
        }
        try {
            JSONObject obj = new JSONObject();
            obj.put(QUICK_REPLIES_KEY, (Object)this.mQuickRepliesString);
            obj.put(TIMESTAMP_KEY, this.mTimestamp);
            obj.put(ORIGINATOR_ID_KEY, (Object)this.mOriginatorId);
            obj.put(SEQUENCE_KEY, this.mSequence);
            obj.put(SHOW_KEY, this.mShow);
            return obj.toString();
        }
        catch (JSONException e) {
            LPMobileLog.w((String)TAG, (String)"getJsonString: error parsing quick reply json");
            return "";
        }
    }

    public boolean isValid() {
        return this.mQuickRepliesString != null && this.mShow;
    }

    public void writeToSharedPreferences() {
        QuickRepliesMessageHolder currentStoredQuickRepliesMessageHolder = QuickRepliesMessageHolder.loadFromSharedPreferences(this.mBrandId);
        if (this.newerOrEqualThan(currentStoredQuickRepliesMessageHolder)) {
            String encryptedJson = DBEncryptionHelper.encrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)this.getJsonString());
            PreferenceManager.getInstance().setStringValue(QUICK_REPLIES_SHARED_PREFERENCES_KEY, this.mBrandId, encryptedJson);
        }
    }

    public void deleteFromSharedPreferences() {
        PreferenceManager.getInstance().remove(QUICK_REPLIES_SHARED_PREFERENCES_KEY, this.mBrandId);
    }

    public static QuickRepliesMessageHolder loadFromSharedPreferences(String brandId) {
        String encryptedJsonString = PreferenceManager.getInstance().getStringValue(QUICK_REPLIES_SHARED_PREFERENCES_KEY, brandId, null);
        String jsonString = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)encryptedJsonString);
        if (jsonString == null) {
            return null;
        }
        return QuickRepliesMessageHolder.fromJsonString(brandId, jsonString);
    }

    public String getQuickRepliesString() {
        return this.mQuickRepliesString;
    }

    public String getOriginatorId() {
        return this.mOriginatorId;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public boolean isShow() {
        return this.mShow;
    }

    public void setShow(boolean show) {
        this.mShow = show;
        this.writeToSharedPreferences();
    }

    public int getSequence() {
        return this.mSequence;
    }

    public boolean newerThan(QuickRepliesMessageHolder quickRepliesMessageHolder) {
        if (quickRepliesMessageHolder == null) {
            return true;
        }
        return this.mSequence > quickRepliesMessageHolder.mSequence;
    }

    public boolean newerOrEqualThan(QuickRepliesMessageHolder quickRepliesMessageHolder) {
        if (quickRepliesMessageHolder == null) {
            return true;
        }
        return this.mSequence >= quickRepliesMessageHolder.mSequence;
    }

    public static void updateQuickReplies(String brandId, String quickReplies) {
        PreferenceManager.getInstance().setStringValue(QUICK_REPLIES_SHARED_PREFERENCES_KEY, brandId, quickReplies);
    }

    public String toString() {
        return "QuickRepliesMessageHolder{mQuickRepliesString='" + this.mQuickRepliesString + '\'' + ", mOriginatorId='" + this.mOriginatorId + '\'' + ", mSequence=" + this.mSequence + ", mTimestamp=" + this.mTimestamp + ", mShow=" + this.mShow + ", mBrandId='" + this.mBrandId + '\'' + '}';
    }
}

