/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.Context;
import android.content.Intent;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.messaging.controller.AccountsController;

public class SynchronizedAuthenticationCompletedCallback
implements Command {
    private static final String TAG = SynchronizedAuthenticationCompletedCallback.class.getSimpleName();
    private final AccountsController mAccountController;
    private String mBrandId;
    private boolean handled = false;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;
    private ICallback<Void, Exception> mCallback;

    public SynchronizedAuthenticationCompletedCallback(AccountsController accountsController, String brandId, ICallback<Void, Exception> callback) {
        this.mAccountController = accountsController;
        this.mBrandId = brandId;
        this.mCallback = callback;
    }

    public void execute() {
        this.executeWithReturnValue();
    }

    public boolean executeWithReturnValue() {
        if (this.isValidAuthentication()) {
            this.handleConnection();
            return true;
        }
        this.registerToConnectionStateChanges();
        this.validateStatusDidNotChangedDuringRegistration();
        return false;
    }

    private boolean isValidAuthentication() {
        return this.mAccountController.getAccount(this.mBrandId) != null && this.mAccountController.getAccount(this.mBrandId).isAuthenticatedCompleted() && !this.mAccountController.getAccount(this.mBrandId).isTokenExpired();
    }

    private void registerToConnectionStateChanges() {
        this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_KEY_AUTH_COMPLETED_ACTION").addAction("BROADCAST_CONNECTING_TO_SERVER_ERROR").build(new LocalBroadcastReceiver.IOnReceive(){

            public void onBroadcastReceived(Context context, Intent intent) {
                if ("BROADCAST_KEY_AUTH_COMPLETED_ACTION".equals(intent.getAction())) {
                    SynchronizedAuthenticationCompletedCallback.this.handleConnection();
                } else if ("BROADCAST_CONNECTING_TO_SERVER_ERROR".equals(intent.getAction())) {
                    SynchronizedAuthenticationCompletedCallback.this.handleError();
                }
            }
        });
    }

    private synchronized void validateStatusDidNotChangedDuringRegistration() {
        if (!this.handled && this.isValidAuthentication()) {
            this.handleConnection();
        }
    }

    private synchronized void handleConnection() {
        if (this.handled) {
            return;
        }
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
        }
        this.handled = true;
        this.mCallback.onSuccess(null);
    }

    private synchronized void handleError() {
        if (this.handled) {
            return;
        }
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
        }
        this.handled = true;
        this.mCallback.onError((Throwable)new Exception("Failed to connect"));
    }
}

