/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.BaseGenerateURL;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.response.IOnUrlReady;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseGetUrlRequest
extends BaseAMSSocketRequest<BaseGenerateURL.Response, BaseGetUrlRequest> {
    private static final String TAG = BaseGetUrlRequest.class.getSimpleName();
    private IOnUrlReady mListener;

    public BaseGetUrlRequest(Messaging controller, String brandId, IOnUrlReady listener) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mListener = listener;
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<BaseGenerateURL.Response, BaseGetUrlRequest> getResponseHandler() {
        return new BaseResponseHandler<BaseGenerateURL.Response, BaseGetUrlRequest>(){

            protected BaseGenerateURL.Response parse(JSONObject jsonObject) throws JSONException {
                return new BaseGenerateURL.Response(jsonObject);
            }

            public BaseResponseHandler getResponseByExpectedType(String expectedType) {
                BaseResponseHandler supportedResponseHandler = this.getSupportedResponseHandler(expectedType);
                if (supportedResponseHandler != null) {
                    return supportedResponseHandler;
                }
                return this;
            }

            protected BaseResponseHandler getSupportedResponseHandler(String messageType) {
                if (TextUtils.equals((CharSequence)messageType, (CharSequence)"StringResponse")) {
                    return new BaseResponseHandler<ReqBody.StringResp, NewConversationRequest>(){

                        public String getAPIResponseType() {
                            return "StringResponse";
                        }

                        protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                            return new ReqBody.StringResp(jsonObject);
                        }

                        protected boolean handle(ReqBody.StringResp response) {
                            LPMobileLog.d((String)TAG, (String)("Received String response (" + response.code + ")."));
                            BaseGetUrlRequest.this.mListener.onUrlError("response code: " + response.code + " error: " + response.getBody());
                            return true;
                        }
                    };
                }
                return super.getSupportedResponseHandler(messageType);
            }

            protected boolean handle(BaseGenerateURL.Response response) {
                if (response.getBody().relativePath == null) {
                    BaseGetUrlRequest.this.mListener.onUrlError("No relative path returned!!");
                } else {
                    BaseGetUrlRequest.this.mListener.onUrlReady(response.getBody());
                }
                return true;
            }

            public String getAPIResponseType() {
                return ".ams.ms.BaseGenerateURL$Response";
            }

            protected void giveUp() {
                super.giveUp();
                String errorMessage = BaseGetUrlRequest.this.getRequestId() + ": Request lost (socket closed) for get url.";
                BaseGetUrlRequest.this.mListener.onUrlError(errorMessage);
                LPMobileLog.i((String)TAG, (String)errorMessage);
            }
        };
    }
}

