/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.GetUserProfile;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.MessagingUserProfile;
import org.json.JSONException;
import org.json.JSONObject;

public class GetUserProfileRequest
extends BaseAMSSocketRequest<GetUserProfile.Response, GetUserProfileRequest> {
    private static final String TAG = GetUserProfile.class.getSimpleName();
    private final String mBrandId;
    private final Messaging mController;
    private String mUserId = "";
    private UserProfile.UserType mType;
    private String serverConversationId = "";
    private boolean mShouldUpdateUI = true;

    public GetUserProfileRequest(Messaging controller, String brandId, String targetId, UserProfile.UserType type) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mBrandId = brandId;
        this.mType = type;
        String mTargetId = targetId;
    }

    public GetUserProfileRequest setUserId(String userId) {
        this.mUserId = userId;
        return this;
    }

    public GetUserProfileRequest setDialogId(String dialogId) {
        this.serverConversationId = dialogId;
        return this;
    }

    public GetUserProfileRequest setServerConversationId(String serverConversationId) {
        this.serverConversationId = serverConversationId;
        return this;
    }

    public GetUserProfileRequest setShouldUpdateUI(boolean shouldUpdateUI) {
        this.mShouldUpdateUI = shouldUpdateUI;
        return this;
    }

    protected String getData() {
        return new GetUserProfile(this.mUserId).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest> getResponseHandler() {
        return new BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest>(){

            public String getAPIResponseType() {
                return "userprofile.GetUserProfileResponse";
            }

            protected GetUserProfile.Response parse(JSONObject jsonObject) throws JSONException {
                return new GetUserProfile.Response(jsonObject);
            }

            protected boolean handle(GetUserProfile.Response data) {
                data.getBody().setUserType(GetUserProfileRequest.this.mType);
                final MessagingUserProfile userProfile = new MessagingUserProfile(data.getBody());
                userProfile.setBrandID(GetUserProfileRequest.this.mBrandId);
                ((GetUserProfileRequest)GetUserProfileRequest.this).mController.amsUsers.updateUserProfile(userProfile);
                if (GetUserProfileRequest.this.mType == UserProfile.UserType.AGENT) {
                    ((GetUserProfileRequest)GetUserProfileRequest.this).mController.amsDialogs.queryDialogById(GetUserProfileRequest.this.serverConversationId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Dialog>(){

                        public void onResult(Dialog data) {
                            if (TextUtils.equals((CharSequence)data.getAssignedAgentId(), (CharSequence)GetUserProfileRequest.this.mUserId) && data.getState() == DialogState.OPEN) {
                                LPMobileLog.d((String)TAG, (String)"onResult: Calling agent details callback");
                                GetUserProfileRequest.this.mController.onAgentDetailsChanged(userProfile, data.isOpen());
                            }
                            LPMobileLog.d((String)TAG, (String)("got user details (" + GetUserProfileRequest.this.mUserId + ") related to conversation: " + GetUserProfileRequest.this.serverConversationId));
                            if (GetUserProfileRequest.this.mShouldUpdateUI) {
                                ((GetUserProfileRequest)GetUserProfileRequest.this).mController.amsMessages.updateAgentDetailsUpdated(GetUserProfileRequest.this.mBrandId, GetUserProfileRequest.this.serverConversationId);
                            }
                        }
                    }).execute();
                }
                return true;
            }
        };
    }
}

