/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.OnActionClickListener;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class LinkAction
extends BaseAction {
    public static final String TAG = LinkAction.class.getSimpleName();
    private String mUri;

    public LinkAction(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        JSONObject androidObject = jsonObject.optJSONObject("android");
        this.mUri = androidObject != null ? androidObject.getString("uri") : jsonObject.getString("uri");
    }

    public LinkAction(String type, String name, String uri) {
        super(type, name);
        this.mUri = uri;
    }

    @Override
    public OnActionClickListener getOnClickListener(final Context context, String brandId) {
        OnActionClickListener onClickListener = new OnActionClickListener(){

            @Override
            public void onClick() {
                if (!TextUtils.isEmpty((CharSequence)LinkAction.this.mUri)) {
                    if (Configuration.getBoolean((int)R.bool.structured_content_link_as_callback)) {
                        MessagingFactory.getInstance().getController().mEventsProxy.onStructuredContentLinkClicked(LinkAction.this.mUri);
                    } else {
                        LPMobileLog.d((String)TAG, (String)("onClick: activating link to: " + LinkAction.this.mUri));
                        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)LinkAction.this.mUri));
                        PackageManager packageManager = context.getPackageManager();
                        if (i.resolveActivity(packageManager) != null) {
                            context.startActivity(i);
                        } else {
                            LPMobileLog.w((String)TAG, (String)("onClick: no activity to handle the action (" + Uri.parse((String)LinkAction.this.mUri) + ")"));
                        }
                    }
                }
            }
        };
        return onClickListener;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + "(\n");
        return sb.toString();
    }

    @Override
    public void accept(ElementVisitor visitor) {
    }

    public String getUri() {
        return this.mUri;
    }
}

