/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.ElementStyle;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class ButtonElement
extends ActionableElement {
    private ElementStyle mStyle;
    public static final String TAG = ButtonElement.class.getSimpleName();
    private String mTitle;

    public ButtonElement() {
        super("button");
    }

    public ButtonElement(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        this.mTitle = (String)jsonObject.get("title");
        JSONObject style = jsonObject.optJSONObject("style");
        this.mStyle = new ElementStyle(style);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " - " + this.mTitle + "\n");
        return sb.toString();
    }

    @Override
    public void accept(ElementVisitor visitor) {
        visitor.visit(this);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public ElementStyle getStyle() {
        return this.mStyle;
    }
}

