/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.ElementStyle;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class TextElement
extends SimpleElement {
    private String mText;
    private ElementStyle mStyle;

    public TextElement() {
        super("text");
    }

    public TextElement(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        this.mText = jsonObject.getString("text");
        JSONObject style = jsonObject.optJSONObject("style");
        this.mStyle = new ElementStyle(style);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " - " + this.mText + "\n");
        return sb.toString();
    }

    @Override
    public void accept(ElementVisitor visitor) {
        visitor.visit(this);
    }

    public void setText(String text) {
        this.mText = text;
    }

    public String getText() {
        return this.mText;
    }

    public ElementStyle getStyle() {
        return this.mStyle;
    }
}

