/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import java.util.Date;
import org.json.JSONObject;

public class TokenUtils {
    public static final String TAG = TokenUtils.class.getSimpleName();
    private static int jwtExpirationBuffer = -1;

    public static boolean isJwtExpired(String jwt) {
        if (jwtExpirationBuffer != -1) {
            jwtExpirationBuffer = Configuration.getInteger((int)R.integer.lp_messaging_buffer_expiration_seconds);
        }
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return false;
        }
        LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)("jwt exists: " + jwt + " checking if expired.."));
        String[] segments = jwt.split("\\.");
        if (segments.length < 3) {
            return false;
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            String secondSegments = new String(secondSegmentsByte, "UTF-8");
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            Long expirationInSeconds = secondSegmentsJson.getLong("exp");
            Long iat = secondSegmentsJson.getLong("iat");
            long expirationInMillis = expirationInSeconds * 1000L;
            LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)("expiration = " + new Date(expirationInMillis).toString()));
            LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)("iat = " + new Date(iat * 1000L).toString()));
            if (TokenUtils.isGoingToExpire(expirationInMillis)) {
                LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)"JWT is expired or about to.. ");
                return true;
            }
            LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)"JWT is still valid ");
        }
        catch (Exception e) {
            LPMobileLog.e((String)TAG, (Throwable)e);
        }
        return false;
    }

    private static boolean isGoingToExpire(long expirationInMillis) {
        long bufferTime = jwtExpirationBuffer * 1000;
        long time = System.currentTimeMillis() + bufferTime;
        return time > expirationInMillis;
    }

    public static String getOriginalConsumerIdFromJWT(String jwt) {
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return "";
        }
        LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)("Getting original consumerId from jwt: " + jwt));
        String[] segments = jwt.split("\\.");
        if (segments.length < 3) {
            return "";
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            String secondSegments = new String(secondSegmentsByte, "UTF-8");
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            JSONObject lpExt = secondSegmentsJson.optJSONObject("lp.ext");
            if (lpExt != null) {
                return lpExt.optString("sub");
            }
        }
        catch (Exception e) {
            LPMobileLog.e((String)TAG, (Throwable)e);
        }
        return "";
    }

    public static String getConsumerUserId(String jwt) {
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return "";
        }
        LPMobileLog.d((String)TAG, (String)"LOGIN_FLOW", (String)("Getting original consumerId from jwt: " + jwt));
        String[] segments = jwt.split("\\.");
        if (segments.length < 3) {
            return "";
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            String secondSegments = new String(secondSegmentsByte, "UTF-8");
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            String sub = secondSegmentsJson.optString("sub");
            return sub;
        }
        catch (Exception e) {
            LPMobileLog.e((String)TAG, (Throwable)e);
            return "";
        }
    }
}

