/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.document;

import android.support.annotation.Nullable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.background.DownloadFileTask;
import com.liveperson.messaging.background.filesharing.DownloadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class DownloadDocumentTask
extends DownloadFileTask {
    private static final String TAG = "DownloadDocumentTask";
    private FileSharingType mSubFileType;
    private File mFilesFolder;
    private static String DOCUMENTS_FOLDER = "documents/";
    private String mBrandId;

    public DownloadDocumentTask(DownloadFileTaskBundle params, FileSharingType subFileType) {
        super(params);
        this.mSubFileType = subFileType;
        this.mFilesFolder = Infra.instance.getApplicationContext().getFilesDir();
        this.mBrandId = params.getBrandId();
    }

    @Override
    protected String saveFileToDisk(byte[] byteArray) {
        return this.saveByteArrayToDisk(byteArray);
    }

    private String saveByteArrayToDisk(byte[] fileByteArray) {
        File filePath = new File(this.getDocumentsFolder(), this.generateDocumentName(this.mSubFileType));
        LPLog.INSTANCE.d(TAG, "saveByteArrayToDisk: filePath: " + filePath.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            fos.write(fileByteArray);
        }
        catch (FileNotFoundException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000B3, "saveByteArrayToDisk: File not found", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000B4, "saveByteArrayToDisk: IOException", (Throwable)e);
        }
        LPLog.INSTANCE.d(TAG, "saveByteArrayToDisk: file absolute path: " + filePath.getAbsolutePath());
        return filePath.getAbsolutePath();
    }

    private String generateDocumentName(FileSharingType fileType) {
        switch (fileType) {
            case DOCX: {
                return UniqueID.createUniqueMessageEventId() + ".docx";
            }
            case PPTX: {
                return UniqueID.createUniqueMessageEventId() + ".pptx";
            }
            case XLSX: {
                return UniqueID.createUniqueMessageEventId() + ".xlsx";
            }
        }
        return UniqueID.createUniqueMessageEventId() + ".pdf";
    }

    @Nullable
    private String getDocumentsFolder() {
        File outgoingDocumentFolder = new File(this.mFilesFolder + "/" + DOCUMENTS_FOLDER + "/" + this.mBrandId);
        if (!outgoingDocumentFolder.exists() && !outgoingDocumentFolder.mkdirs()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000B5, "getDocumentsFolder: /documents folder could not be created");
            return null;
        }
        return outgoingDocumentFolder.getPath();
    }
}

