/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.Dialog;

public class DataBaseTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "DataBaseTask";
    private final AmsUsers mAmsUsers;
    private final AmsConversations mAmsConversations;
    private final AmsDialogs mAmsDialogs;

    public DataBaseTask(AmsUsers amsUsers, AmsConversations amsConversations, AmsDialogs amsDialogs) {
        this.mAmsUsers = amsUsers;
        this.mAmsConversations = amsConversations;
        this.mAmsDialogs = amsDialogs;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running Database loading task...");
        AmsConnectionAnalytics.databaseTaskStart();
        DataBaseExecutor.execute(() -> {
            this.mAmsUsers.loadConsumerForBrand(this.mBrandId);
            this.mAmsConversations.loadOpenConversationForBrand(this.mBrandId);
            this.mAmsDialogs.loadOpenDialogsForBrand(this.mBrandId);
            Dialog dialog = this.mAmsDialogs.getActiveDialog();
            if (dialog != null) {
                this.mAmsUsers.loadProfile(dialog.getAssignedAgentId());
            }
            AmsConnectionAnalytics.databaseTaskEnd();
            this.mCallback.onTaskSuccess();
        });
    }

    @Override
    public String getName() {
        return TAG;
    }
}

