/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.util.SparseIntArray;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.BasicQueryMessagesCommand;
import com.liveperson.messaging.commands.QueryMessagesUMSCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager;
import com.liveperson.messaging.commands.tasks.UpdateEmptyDialogCommand;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.DialogUtils;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.network.http.QueryMessagesINCACommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class FetchConversationManager {
    private static final String TAG = "FetchConversationManager";
    protected final Messaging mController;
    private ConversationUtils mConversationUtils;
    private DialogUtils mDialogUtils;
    private Set<String> usersUpdating = new HashSet<String>();
    private int numConversationToUpdateUI;
    private final HashMap<String, LocalBroadcastReceiver> didDialogGetMessages = new HashMap();
    private static Map<String, Conversation> pendingConversationsToRefresh = new HashMap<String, Conversation>();

    public FetchConversationManager(Messaging controller) {
        this.mController = controller;
        this.init();
    }

    protected void init() {
        this.mConversationUtils = new ConversationUtils(this.mController);
        this.mDialogUtils = new DialogUtils(this.mController);
    }

    public void fetchConversationsFirstTime(String brandId, List<ConversationData> dataFromUMS, List<ConversationData> dataFromInca) {
        int incaSize;
        if (this.isCollectionEmpty(dataFromUMS) && this.isCollectionEmpty(dataFromInca)) {
            this.mController.mConnectionController.getConnection(brandId).setIsUpdated(true);
            this.mController.amsMessages.updateFetchHistoryEnded(true);
            return;
        }
        int numConversationToFetch = Configuration.getInteger((int)R.integer.idp_num_history_conversation);
        if (numConversationToFetch < 0) {
            numConversationToFetch = 2;
        }
        int umsSize = this.isCollectionEmpty(dataFromUMS) ? 0 : dataFromUMS.size();
        int n = incaSize = this.isCollectionEmpty(dataFromInca) ? 0 : dataFromInca.size();
        if (umsSize + incaSize < numConversationToFetch) {
            numConversationToFetch = umsSize + incaSize;
        }
        this.numConversationToUpdateUI = numConversationToFetch;
        if (numConversationToFetch > 0) {
            boolean shouldFetchMessages;
            ArrayBlockingQueue<QueryRequestMessage> queue = new ArrayBlockingQueue<QueryRequestMessage>(numConversationToFetch * 2);
            this.waitFetchConversationFinished(brandId, numConversationToFetch, queue, true);
            int i = 0;
            if (dataFromUMS != null) {
                for (ConversationData conversationData : dataFromUMS) {
                    if (conversationData.state == ConversationState.CLOSE && this.isConversationPresentInHistory(conversationData, dataFromInca)) continue;
                    shouldFetchMessages = i < numConversationToFetch;
                    LPLog.INSTANCE.d(TAG, "Saving conversation #" + i + " source: UMS. bringing messages: " + shouldFetchMessages);
                    this.fetchConversation(conversationData, shouldFetchMessages, queue, i, DATA_SOURCE.UMS);
                    ++i;
                }
            }
            if (dataFromInca != null) {
                for (ConversationData conv : dataFromInca) {
                    shouldFetchMessages = i < numConversationToFetch;
                    LPLog.INSTANCE.d(TAG, "Saving conversation #" + i + " source: INCA. bringing messages: " + shouldFetchMessages);
                    this.fetchConversation(conv, shouldFetchMessages, queue, i, DATA_SOURCE.INCA);
                    ++i;
                }
            }
            LPLog.INSTANCE.d(TAG, "Finished updating conversations in DB. waiting for query messages responses (if there is))");
        } else {
            int i = 0;
            for (ConversationData conversationData : dataFromUMS) {
                this.fetchConversation(conversationData, false, null, i, DATA_SOURCE.UMS);
                ++i;
            }
            for (ConversationData conversationData : dataFromInca) {
                this.fetchConversation(conversationData, false, null, i, DATA_SOURCE.INCA);
                ++i;
            }
            this.mController.amsMessages.updateOnCommand().setPreQueryOnBackground(() -> {
                LPLog.INSTANCE.d(TAG, "Finished updating conversations in DB. waiting for query messages responses (if there is))");
                this.mController.mConnectionController.getConnection(brandId).setIsUpdated(true);
            }).execute();
        }
    }

    private boolean isCollectionEmpty(List<ConversationData> collection) {
        return collection == null || collection.size() == 0;
    }

    private boolean isConversationPresentInHistory(ConversationData UMSConversation, List<ConversationData> historyConversations) {
        if (UMSConversation == null) {
            return true;
        }
        if (historyConversations == null) {
            return false;
        }
        for (ConversationData conversation : historyConversations) {
            if (!conversation.conversationId.equals(UMSConversation.conversationId)) continue;
            return true;
        }
        LPLog.INSTANCE.i(TAG, "isConversationPresentInHistory: UMS conversation " + UMSConversation.conversationId + " is missing from INCA conversations list. Fetch it from UMS.");
        return false;
    }

    public void fetchConversation(Conversation conversation, ArrayList<Dialog> dialogs) {
        if (!this.mController.mConnectionController.isSocketReady(conversation.getBrandId())) {
            LPLog.INSTANCE.i(TAG, "Brand is not connected. can't fetch dialog for " + conversation.getConversationId());
            this.mController.amsMessages.updateFetchHistoryEnded(false);
            return;
        }
        this.fetchConversation(conversation, dialogs, false, true);
    }

    public void refreshPendingConversation(String conversationId) {
        if (conversationId == null || pendingConversationsToRefresh == null) {
            return;
        }
        Conversation conversation = pendingConversationsToRefresh.get(conversationId);
        if (conversation != null) {
            pendingConversationsToRefresh.remove(conversationId);
            this.refreshConversation(conversation);
        }
    }

    public void refreshConversation(Conversation conversation) {
        ArrayList<Dialog> dialogs = this.mController.amsDialogs.getDialogsByConversationId(conversation.getConversationId());
        if (dialogs.size() == 0) {
            LPLog.INSTANCE.d(TAG, "refreshConversation: dialogs not found in memory, checking database...");
            this.mController.amsDialogs.queryDialogsByConversationId(conversation.getConversationId()).setPostQueryOnBackground(fetchedDialogs -> {
                if (fetchedDialogs == null || fetchedDialogs.size() <= 0) {
                    pendingConversationsToRefresh.put(conversation.getConversationId(), conversation);
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000064, "refreshConversation: Missing dialogs for conversation ID:" + conversation.getConversationId());
                    throw new RuntimeException("refreshConversation: Missing dialogs for conversation ID:" + conversation.getConversationId());
                }
                LPLog.INSTANCE.d(TAG, "refreshConversation: dialogs found in database. Re-fetch conversation: " + conversation.getConversationId());
                this.fetchConversation(conversation, (ArrayList<Dialog>)fetchedDialogs, true, false);
            }).execute();
        } else {
            LPLog.INSTANCE.d(TAG, "refreshConversation: dialogs found in memory. Re-fetch conversation: " + conversation.getConversationId());
            this.fetchConversation(conversation, dialogs, true, false);
        }
    }

    private void fetchConversation(Conversation conversation, ArrayList<Dialog> dialogs, boolean forceUpdateAgent, boolean addResolveMessage) {
        ArrayBlockingQueue<QueryRequestMessage> queue = new ArrayBlockingQueue<QueryRequestMessage>(dialogs.size());
        this.waitFetchConversationFinished(conversation.getBrandId(), 1, queue, addResolveMessage);
        for (Dialog dialog : dialogs) {
            if (dialog != null) {
                String assignedAgentId = dialog.getAssignedAgentId();
                this.numConversationToUpdateUI = 1;
                ConversationData conversationData = new ConversationData(conversation.getBrandId(), conversation, dialogs);
                DATA_SOURCE source = conversation.isConversationOpen() ? DATA_SOURCE.UMS : DATA_SOURCE.INCA;
                LPLog.INSTANCE.i(TAG, "Fetching dialog for " + conversation.getConversationId() + " sending request to query unread messages via " + source.name());
                this.queryMessages(conversationData, dialog, queue, 0, source);
                this.mConversationUtils.updateParticipants(conversation.getTargetId(), new String[]{assignedAgentId}, UserProfile.UserType.AGENT, dialog.getConversationId(), false, forceUpdateAgent);
                continue;
            }
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000065, "fetchConversation: Missing open dialog in conversation: " + conversation.getConversationId());
        }
    }

    private void waitFetchConversationFinished(final String brandId, final int maxConversationHistory, final BlockingQueue<QueryRequestMessage> queue, final boolean addResolveMessage) {
        new Thread(new Runnable(){
            LocalBroadcastReceiver mConnectionReceiver;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ArrayList<1> resolveMessagesListeners = new ArrayList<1>();
                boolean isTimedOut = false;
                QueryRequestMessage prevQueryRequestMessage = null;
                try {
                    if (!InternetConnectionService.isNetworkAvailable()) {
                        LPLog.INSTANCE.d(FetchConversationManager.TAG, "Can't fetch history from server. no network. ");
                        throw new IllegalStateException("Can't fetch history from server.  no network.");
                    }
                    this.registerNoConnectionEvents();
                    final SparseIntArray conversationsQueryMap = new SparseIntArray(maxConversationHistory);
                    boolean done = false;
                    while (!done) {
                        QueryRequestMessage queryRequestMessage = (QueryRequestMessage)queue.poll(15L, TimeUnit.SECONDS);
                        if (queryRequestMessage != null) {
                            if (queryRequestMessage.conversationData != null && queryRequestMessage.conversationData.dialogs != null) {
                                DialogData[] dialogs;
                                for (DialogData dialog : dialogs = queryRequestMessage.conversationData.dialogs) {
                                    String dialogId = dialog.dialogId;
                                    HashMap hashMap = FetchConversationManager.this.didDialogGetMessages;
                                    synchronized (hashMap) {
                                        if (FetchConversationManager.this.didDialogGetMessages.get(dialogId) == null) {
                                            LocalBroadcastReceiver broadcastReceiver = new LocalBroadcastReceiver.Builder().addAction(MessagingEventSubscriptionManager.Companion.getMESSAGE_EVENT_COMPLETED() + dialogId).build((context, intent) -> {
                                                LocalBroadcastReceiver receiver = (LocalBroadcastReceiver)FetchConversationManager.this.didDialogGetMessages.get(dialogId);
                                                if (receiver != null) {
                                                    receiver.unregister();
                                                }
                                            });
                                            FetchConversationManager.this.didDialogGetMessages.put(dialogId, broadcastReceiver);
                                        }
                                    }
                                }
                            }
                            LPLog.INSTANCE.d(FetchConversationManager.TAG, "waitFetchConversationFinished: didDialogGetMessages == " + FetchConversationManager.this.didDialogGetMessages.size());
                            prevQueryRequestMessage = queryRequestMessage;
                        }
                        if (queryRequestMessage == null || queryRequestMessage.conversationIndex == -1) {
                            LPLog.INSTANCE.w(FetchConversationManager.TAG, "Fetching history thread was interrupted or timeout expired");
                            done = true;
                            isTimedOut = true;
                            continue;
                        }
                        int oldValue = conversationsQueryMap.get(queryRequestMessage.conversationIndex);
                        int newValue = oldValue + queryRequestMessage.value;
                        boolean success = queryRequestMessage.success;
                        conversationsQueryMap.put(queryRequestMessage.conversationIndex, newValue);
                        LPLog.INSTANCE.d(FetchConversationManager.TAG, "query maps requests " + conversationsQueryMap + " new value = " + newValue + " addResolveMessage = " + addResolveMessage + " success = " + success);
                        if (newValue != 0) continue;
                        ConversationData conversationData = queryRequestMessage.conversationData;
                        if (success && addResolveMessage && this.containsClosedDialog(conversationData) && conversationData.closeReason != CloseReason.TIMEOUT && conversationData.closeReason != CloseReason.SYSTEM) {
                            final QueryRequestMessage finalQueryRequestMessage = prevQueryRequestMessage;
                            ICallback<Void, Exception> listener = new ICallback<Void, Exception>(){

                                public void onSuccess(Void v) {
                                    this.checkIsDoneFetching();
                                }

                                public void onError(Exception e) {
                                    LPLog.INSTANCE.w(FetchConversationManager.TAG, "Failed adding resolve message.", (Throwable)e);
                                    this.checkIsDoneFetching();
                                }

                                private void checkIsDoneFetching() {
                                    resolveMessagesListeners.remove(this);
                                    if (resolveMessagesListeners.isEmpty() && conversationsQueryMap.size() == 0) {
                                        this.finishFetching(finalQueryRequestMessage, false);
                                    }
                                }
                            };
                            resolveMessagesListeners.add(listener);
                            this.addResolveMessageToClosedConversation(queryRequestMessage, listener);
                        }
                        done = this.isDone(conversationsQueryMap);
                    }
                    conversationsQueryMap.clear();
                }
                catch (Exception e) {
                    LPLog.INSTANCE.w(FetchConversationManager.TAG, "Failed fetching messages from history: ", (Throwable)e);
                }
                finally {
                    FetchConversationManager.this.usersUpdating.clear();
                    if (this.mConnectionReceiver != null) {
                        this.mConnectionReceiver.unregister();
                    }
                    if (!resolveMessagesListeners.isEmpty()) {
                        LPLog.INSTANCE.d(FetchConversationManager.TAG, "Finished fetching messages from history but we are still waiting for Resolve messages to be added to DB...");
                    } else {
                        this.finishFetching(prevQueryRequestMessage, isTimedOut);
                    }
                }
            }

            protected boolean isDone(SparseIntArray conversationsQueryMap) {
                if (conversationsQueryMap.get(maxConversationHistory - 1, -1) == 0) {
                    for (int j = 0; j < maxConversationHistory; ++j) {
                        int value = conversationsQueryMap.get(j, -1);
                        if (value != 0) {
                            return false;
                        }
                        if (j != maxConversationHistory - 1) continue;
                        return true;
                    }
                }
                return false;
            }

            protected void finishFetching(QueryRequestMessage queryRequestMessage, boolean timedOut) {
                if (!FetchConversationManager.this.mController.mConnectionController.getConnection(brandId).isUpdated() && FetchConversationManager.this.mController.mConnectionController.isSocketReady(brandId)) {
                    FetchConversationManager.this.mController.mConnectionController.getConnection(brandId).setIsUpdated(true);
                }
                FetchConversationManager.this.updateFetchHistoryListener(queryRequestMessage, timedOut);
                LPLog.INSTANCE.d(FetchConversationManager.TAG, "Finished fetching messages from history ! ");
            }

            private void registerNoConnectionEvents() {
                this.mConnectionReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_KEY_SOCKET_READY_ACTION").build((context, intent) -> {
                    boolean isConnected = intent.getBooleanExtra("BROADCAST_KEY_SOCKET_READY_EXTRA", false);
                    if (!isConnected) {
                        if (this.mConnectionReceiver != null) {
                            this.mConnectionReceiver.unregister();
                        }
                        queue.add(new QueryRequestMessage(-1, -1, null, false));
                    }
                });
            }

            private boolean containsClosedDialog(ConversationData conversationData) {
                if (conversationData.state == ConversationState.CLOSE) {
                    return true;
                }
                ArrayList<Dialog> conversationDialogs = AmsDialogs.extractDialogs(conversationData);
                for (Dialog dialog : conversationDialogs) {
                    if (dialog.getState() != DialogState.CLOSE) continue;
                    return true;
                }
                return false;
            }

            private void addResolveMessageToClosedConversation(QueryRequestMessage queryRequestMessage, ICallback<Void, Exception> listener) {
                ConversationData conversationData = queryRequestMessage.conversationData;
                LPLog.INSTANCE.d(FetchConversationManager.TAG, "Adding resolve message to " + conversationData.conversationId + " index = " + queryRequestMessage.conversationIndex + " numConversationToUpdateUI = " + FetchConversationManager.this.numConversationToUpdateUI);
                ArrayList<Dialog> conversationDialogs = AmsDialogs.extractDialogs(conversationData);
                for (Dialog dialog : conversationDialogs) {
                    if (dialog.getState() != DialogState.CLOSE) continue;
                    FetchConversationManager.this.mDialogUtils.addClosedDialogDivider(conversationData.targetId, dialog, conversationData.getAssignedAgentId(), dialog.getCloseReason(), queryRequestMessage.conversationIndex >= FetchConversationManager.this.numConversationToUpdateUI, listener);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFetchHistoryListener(QueryRequestMessage queryRequestMessage, boolean timedOut) {
        if (timedOut) {
            HashMap<String, LocalBroadcastReceiver> hashMap = this.didDialogGetMessages;
            synchronized (hashMap) {
                for (String dialogId : this.didDialogGetMessages.keySet()) {
                    LocalBroadcastReceiver broadcastReceiver = this.didDialogGetMessages.get(dialogId);
                    if (broadcastReceiver == null) continue;
                    if (broadcastReceiver.isRegistered()) {
                        LPLog.INSTANCE.d(TAG, "updateFetchHistoryListener: dialog ID has no messages: " + dialogId);
                        this.handleEmptyDialog(queryRequestMessage, dialogId, new BaseAmsSocketConnectionCallback(){

                            @Override
                            public void onTaskSuccess() {
                                FetchConversationManager.this.mController.amsMessages.updateFetchHistoryEnded(true);
                            }

                            @Override
                            public void onTaskError(SocketTaskType type, Throwable exception) {
                                FetchConversationManager.this.mController.amsMessages.updateFetchHistoryEnded(true);
                            }
                        });
                    }
                    broadcastReceiver.unregister();
                }
                this.didDialogGetMessages.clear();
            }
        } else {
            this.mController.amsMessages.updateFetchHistoryEnded(true);
        }
    }

    private void handleEmptyDialog(QueryRequestMessage queryRequestMessage, String dialogId, BaseAmsSocketConnectionCallback callback) {
        if (queryRequestMessage != null && queryRequestMessage.conversationData != null) {
            LPLog.INSTANCE.i(TAG, FlowTags.DIALOGS, "QueryRequest timed out - ERR_00000066");
            UpdateEmptyDialogCommand command = new UpdateEmptyDialogCommand(this.mController, queryRequestMessage.conversationData.brandId, queryRequestMessage.conversationData.conversationId, dialogId, true);
            command.setResponseCallBack(callback);
            command.execute();
        }
    }

    private void fetchConversation(ConversationData data, boolean queryMessages, BlockingQueue<QueryRequestMessage> queue, int conversationIndex, DATA_SOURCE source) {
        switch (data.state) {
            case CLOSE: {
                this.mController.amsConversations.updateClosedConversation(data, false).setPostQueryOnBackground(updatedConversation -> {
                    ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
                    for (Dialog dialog : dialogs) {
                        this.mController.amsDialogs.updateClosedDialog(data, dialog, false).executeSynchronously();
                        if (!queryMessages) continue;
                        if (updatedConversation != null) {
                            LPLog.INSTANCE.d(TAG, "Sending request to query unread messages... newer than sequence: " + updatedConversation.getLastServerSequence() + " source = " + (Object)((Object)source));
                            this.queryMessages(data, dialog, queue, conversationIndex, source);
                            continue;
                        }
                        this.addRequestToQueue(queue, conversationIndex, data, 0);
                    }
                    this.updateAllUsersRelatedToConversation(data, queryMessages, queue, conversationIndex);
                }).execute();
                break;
            }
            case OPEN: {
                this.mController.amsConversations.createNewCurrentConversation(data);
                ArrayList<Dialog> dialogs = AmsDialogs.extractDialogs(data);
                Dialog dialog = AmsDialogs.getOpenDialog(dialogs);
                for (Dialog d : dialogs) {
                    this.mController.amsDialogs.createNewCurrentDialog(d);
                }
                this.mController.amsDialogs.setActiveDialog(dialog);
                long effectiveTTR = this.mConversationUtils.calculateEffectiveTTR(data.brandId, data.ttrValue, data.manualTTR, data.delayTillWhen);
                this.mConversationUtils.updateTTR(data.conversationTTRType, effectiveTTR, data.brandId);
                if (dialog != null) {
                    LPLog.INSTANCE.d(TAG, "We have a new Current Dialog! " + dialog.getDialogId() + ". Sending request to query messages and update assigned agent details");
                }
                this.updateAllUsersRelatedToConversation(data, queryMessages, queue, conversationIndex);
                if (!queryMessages) break;
                this.queryMessages(data, dialog, queue, conversationIndex, source);
            }
        }
    }

    private void updateAllUsersRelatedToConversation(ConversationData data, boolean isBringingData, BlockingQueue<QueryRequestMessage> queue, int conversationIndex) {
        for (String user : data.participants.ALL_AGENTS) {
            this.getDataForUser(data, user, UserProfile.UserType.AGENT, isBringingData, queue, conversationIndex);
        }
        for (String user : data.participants.CONTROLLER) {
            this.getDataForUser(data, user, UserProfile.UserType.CONTROLLER, isBringingData, queue, conversationIndex);
        }
    }

    private void getDataForUser(final ConversationData data, String user, UserProfile.UserType userType, boolean isBringingData, final BlockingQueue<QueryRequestMessage> queue, final int conversationIndex) {
        if (!this.usersUpdating.contains(user)) {
            this.usersUpdating.add(user);
            ICallback<MessagingUserProfile, Exception> callback = null;
            if (isBringingData) {
                LPLog.INSTANCE.d(TAG, "Bringing user data for conversation index: " + conversationIndex + " agent: " + user);
                this.addRequestToQueue(queue, conversationIndex, data, 1);
                callback = new ICallback<MessagingUserProfile, Exception>(){

                    public void onSuccess(MessagingUserProfile value) {
                        LPLog.INSTANCE.d(FetchConversationManager.TAG, "onSuccess Bringing user data for conversation index: " + conversationIndex);
                        FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, data, -1, true);
                    }

                    public void onError(Exception exception) {
                        LPLog.INSTANCE.d(FetchConversationManager.TAG, "onError Bringing user data for conversation index: " + conversationIndex);
                        FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, data, -1, true);
                    }
                };
            }
            this.mConversationUtils.updateParticipants(data.targetId, new String[]{user}, userType, null, false, true, callback);
        }
    }

    private void queryMessages(final ConversationData conversationData, Dialog dialog, final BlockingQueue<QueryRequestMessage> queue, final int conversationIndex, DATA_SOURCE source) {
        BasicQueryMessagesCommand command = null;
        switch (source) {
            case UMS: {
                command = new QueryMessagesUMSCommand(this.mController, conversationData.brandId, conversationData.conversationId, dialog.getDialogId(), dialog.getLastServerSequence(), false);
                break;
            }
            case INCA: {
                if ("TEMP_CONVERSATION".equals(conversationData.conversationId) || "TEMP_DIALOG".equals(dialog.getDialogId())) {
                    return;
                }
                command = new QueryMessagesINCACommand(this.mController, conversationData.brandId, conversationData.conversationId, dialog.getDialogId(), false);
            }
        }
        command.setResponseCallBack(new BaseAmsSocketConnectionCallback(){

            @Override
            public void onTaskSuccess() {
                FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, conversationData, -1, true);
            }

            @Override
            public void onTaskError(SocketTaskType type, Throwable exception) {
                FetchConversationManager.this.addResponseToQueue(queue, conversationIndex, conversationData, -1, false);
            }
        });
        this.addRequestToQueue(queue, conversationIndex, conversationData, 1);
        command.execute();
    }

    private void addRequestToQueue(BlockingQueue<QueryRequestMessage> queue, int conversationIndex, ConversationData conversationData, int value) {
        try {
            LPLog.INSTANCE.d(TAG, "#" + conversationIndex + " Adding " + value + " to queue");
            queue.put(new QueryRequestMessage(conversationIndex, value, conversationData, true));
        }
        catch (InterruptedException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000067, "#" + conversationIndex + " Problem adding to query messages queue", (Throwable)e);
        }
    }

    private void addResponseToQueue(BlockingQueue<QueryRequestMessage> queue, int conversationIndex, ConversationData conversationData, int value, boolean success) {
        try {
            LPLog.INSTANCE.d(TAG, "#" + conversationIndex + " Adding " + value + " to queue");
            queue.put(new QueryRequestMessage(conversationIndex, value, conversationData, success));
        }
        catch (InterruptedException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000068, "#" + conversationIndex + " Problem adding to query messages queue", (Throwable)e);
        }
    }

    private class QueryRequestMessage {
        int conversationIndex;
        int value;
        boolean success;
        ConversationData conversationData;

        public QueryRequestMessage(int conversationIndex, int value, ConversationData conversationData, boolean success) {
            this.conversationIndex = conversationIndex;
            this.value = value;
            this.conversationData = conversationData;
            this.success = success;
        }
    }

    public static enum DATA_SOURCE {
        UMS,
        INCA;

    }
}

