/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.commands.tasks.FetchConversationManager;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.SynchronizedAmsConnectionUpdateCallback;

public class RefreshNotUpdatedConversationsTask
extends BaseAmsSocketConnectionTask {
    private static final String TAG = "RefreshNotUpdatedConversationsTask";
    private final Messaging mController;

    public RefreshNotUpdatedConversationsTask(Messaging controller) {
        this.mController = controller;
    }

    public void execute() {
        new SynchronizedAmsConnectionUpdateCallback(this.mController.mConnectionController, this.mBrandId, () -> {
            LPLog.INSTANCE.d(TAG, "run RefreshNotUpdatedConversationsTask");
            this.mController.amsConversations.getNotUpdatedConversations(this.mBrandId).setPostQueryOnBackground(conversations -> {
                FetchConversationManager fetchConversationManager = new FetchConversationManager(this.mController);
                if (conversations == null || conversations.size() == 0) {
                    LPLog.INSTANCE.d(TAG, "All conversation are up to date.");
                } else {
                    for (Conversation conversation : conversations) {
                        if (this.mController.amsConversations.isRefreshingConversation(conversation.getConversationId())) {
                            LPLog.INSTANCE.d(TAG, "Conversation is already been refreshed: " + conversation.getConversationId());
                            continue;
                        }
                        LPLog.INSTANCE.d(TAG, "refreshing conversation : " + conversation.getConversationId());
                        String conversationServerId = conversation.getConversationId();
                        this.mController.amsConversations.setUpdateRequestInProgress(conversationServerId, 0);
                        fetchConversationManager.refreshConversation(conversation);
                    }
                    LPLog.INSTANCE.d(TAG, "finished refreshing " + conversations.size() + " conversations");
                }
            }).execute();
        }).execute();
        this.mCallback.onTaskSuccess();
    }
}

