package com.liveperson.api.request;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by adic on 5/18/15.
 */
public abstract class AbstractRequest {

    private static final String JSON_KEY_ID = "id";
    protected static final String JSON_KEY_TYPE = "type";
    private static final String JSON_KEY_KIND = "kind";
    protected static final String JSON_KEY_BODY = "body";
    private static final String TAG = AbstractRequest.class.getSimpleName();
    protected JSONObject body = new JSONObject();

    public String toJsonString(long requestId) {
        JSONObject json = new JSONObject();
        try {
            json.put(JSON_KEY_ID, requestId);
            json.put(JSON_KEY_TYPE, getMessageType());
            json.put(JSON_KEY_KIND, "req");

            toJson(json);
        } catch (JSONException e) {
        }

        return json.toString();
    }

    protected abstract String getMessageType();

    protected abstract void toJson(JSONObject json) throws JSONException;
}
