package com.liveperson.api.request;

import com.liveperson.api.request.AbstractRequest;
import com.liveperson.api.request.BaseGenerateURL;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by shiranr on 03/07/2016.
 */
public class GenerateURLForUploadFile extends BaseGenerateURL {
    public static final String GENERATE_URL_FOR_UPLOAD_FILE_TYPE = "ms.GenerateURLForUploadFile";

    public static final String FILE_SIZE = "fileSize";
    public static final String FILE_TYPE = "fileType";

    String fileType;
    int fileSize;

    public GenerateURLForUploadFile(String fileType, int fileSize) {
        this.fileType = fileType;
        this.fileSize = fileSize;
    }

    @Override
    protected String getMessageType() {
        return GENERATE_URL_FOR_UPLOAD_FILE_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        JSONObject body = new JSONObject();
        body.put(FILE_TYPE, fileType);
        body.put(FILE_SIZE, String.valueOf(fileSize));
        json.put(AbstractRequest.JSON_KEY_BODY, body);

    }



}
