package com.liveperson.api.request;


import com.liveperson.api.response.AbstractResponse;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/10/2015.
 */
public class RequestConversation extends AbstractRequest {

    public static final String CONVERSATION_ID = "conversationId";
    public static final String REQUEST_CONVERSATION_TYPE = "cm.RequestConversation";

    @Override
    public String getMessageType() {
        return REQUEST_CONVERSATION_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {

    }

    public static class Response extends AbstractResponse<Response.Body> {
        Body body = new Body();
        public static final String REQUEST_CONVERSATION_RESPONSE_TYPE = "cm.RequestConversationResponse";

        public Response(JSONObject obj) throws JSONException {
            super(obj);

            JSONObject innerBody = obj.getJSONObject(JSON_KEY_BODY);
            body.conversationId = innerBody.getString(CONVERSATION_ID);
        }

        @Override
        public Response.Body getBody() {
            return body;
        }

        public static class Body {
            public String conversationId;

            @Override
            public String toString() {
                return conversationId;
            }
        }

        @Override
        public String toString() {
            return "{ response: { body: '" + getBody().toString() + "' } }";
        }
    }
}
