package com.liveperson.api.request;


import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Ofer Davidyan on 8/9/2015.
 */
public class UnsubscribeExConversations extends AbstractRequest {

    public static final String TAG = UnsubscribeExConversations.class.getSimpleName();
    private static final String SUBSCRIPTION_ID = "subscriptionId";


    private String subscriptionId = null;

    public UnsubscribeExConversations(String subscriptionId) {
        super();
        this.subscriptionId = subscriptionId;
    }

    @Override
    public String getMessageType() {
        return "cqm.UnsubscribeExConversations";
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        body.put(SUBSCRIPTION_ID, subscriptionId);
        json.put(AbstractRequest.JSON_KEY_BODY, body);
    }


    ///////////////////////////////////////////
    // no response defined in the protocol,
    // maybe it should be just Ack ????
    ///////////////////////////////////////////

//    public static class Response extends AbstractResponse
//    {
//        public String subscriptionId;
//
//        public Response(JSONObject obj) throws JSONException
//        {
//            super(obj);
//            subscriptionId = obj.getJSONObject("body").getString("subscriptionId");
//        }
//
//        @Override
//        public String getBody()
//        {
//            return null;
//        }
//    }

}
