package com.liveperson.api.request;


import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.CsatStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.messaging.model.AmsDialogs;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/9/2015.
 */
public class UpdateConversationField extends AbstractRequest {

    public static final String CONVERSATION_STAGE_FIELD = "Stage";
    @Deprecated
    private static final String CONVERSATION_STATE_FIELD = "ConversationStateField";

    /**
     * This is a temp method (it shouldn't exist on versions newer than 3.3) that helps in determining which if the fields should be in use (the deprecated one or the new one).
     * @return
     */
    public static String CONVERSATION_STATE_FIELD() {
        return AmsDialogs.isUmsSupportingDialogs() ? CONVERSATION_STAGE_FIELD : CONVERSATION_STATE_FIELD;
    }

    public static final String CONVERSATION_CSAT_RATE = "CSATRate";
    public static final String TTR_FIELD = "TTRField";
    public static final String UPDATE_CONVERSATION_FIELD_TYPE = "cm.UpdateConversationField";
    private static final String UPDATE = "UPDATE";

    public static final String CONVERSATION_ID = "conversationId";
    public static final String FIELD = "field";
    @Deprecated
    public static final String CONVERSATION_STATE = "conversationState";
    public static final String CONVERSATION_STAGE = "stage";
    public static final String CONVERSATION_CSAT = "csatRate";
    public static final String CONVERSATION_CSAT_YESNO_VALUE = "csatResolutionConfirmation";
    public static final String CONVERSATION_CSAT_STATUS = "status";
    public static final String CONVERSATION_FIELD = "conversationField";
    public static final String PARTICIPANTS_CHANGE_FIELD = "ParticipantsChange";
    public static final String DIALOG_CHANGE_FIELD = "DialogChange";

    public static final String TTR = "ttrType";
    private static final String TTR_VALUE = "value";
    public String conversationId;
    public String dialogId;
    public String field;
    public ConversationState conversationState;
    public DialogState dialogState;
    public TTRType ttrType;
    public int ttrValue;
    public int csatNumberOfStars;
    public int csatYesNoValue;
    public CsatStatus csatStatus;
    public String type;
    private String closingCause;

    public UpdateConversationField(String dialogId,
                                   String conversationId,
                                   String field,
                                   String closingCause,
                                   DialogState dialogState) {
        type = UPDATE;
        this.closingCause = closingCause;
        this.conversationId = conversationId;
        this.dialogId = dialogId;
        this.field = field;
        this.dialogState = dialogState;
    }

    public UpdateConversationField(String conversationId,
                                   String field,
                                   ConversationState conversationState) {
        this.conversationId = conversationId;
        this.field = field;
        this.conversationState = conversationState;
    }

    public UpdateConversationField(String convId, String field, int numberOfStars, int csatYesNoValue, CsatStatus status) {
        this.conversationId = convId;
        this.field = field;
        this.csatNumberOfStars = numberOfStars;
        this.csatYesNoValue = csatYesNoValue;
        this.csatStatus = status;
    }

    public UpdateConversationField(String convId, String field, TTRType ttrType, int value) {
        this.conversationId = convId;
        this.field = field;
        this.ttrType = ttrType;
        this.ttrValue = value;
    }

    @Override
    public String getMessageType() {
        return UPDATE_CONVERSATION_FIELD_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        body.put(CONVERSATION_ID, conversationId);

        JSONObject conversationField = new JSONObject();
        conversationField.put(FIELD, field);
        switch (field) {
            case CONVERSATION_STAGE_FIELD: {
                conversationField.put(CONVERSATION_STAGE, conversationState.name());
                break;
            }
            case CONVERSATION_STATE_FIELD: {
                conversationField.put(CONVERSATION_STATE, conversationState.name());
                break;
            }
            case CONVERSATION_CSAT_RATE: {
                if (csatYesNoValue > -1) {
                    conversationField.put(CONVERSATION_CSAT_YESNO_VALUE, csatYesNoValue == 1);
                }
                if(csatNumberOfStars == -1){
                    conversationField.put(CONVERSATION_CSAT, JSONObject.NULL);
                }else{
                    conversationField.put(CONVERSATION_CSAT, csatNumberOfStars);
                }
                conversationField.put(CONVERSATION_CSAT_STATUS, csatStatus.name());
                break;
            }
            case TTR_FIELD: {
                conversationField.put(TTR, ttrType.name());
                conversationField.put(TTR_VALUE, ttrValue);
            }
                break;
            case DIALOG_CHANGE_FIELD: {
                JSONObject dialogObject = new JSONObject();
                dialogObject.put("dialogId", dialogId);
                dialogObject.put("state", dialogState.name());
                if (dialogState == DialogState.CLOSE) {
                    dialogObject.put("closedBy", CloseReason.CONSUMER.name());
//                    if (closingCause == null) {
//                        closingCause = "";
//                    }
                    //dialogObject.put("closedCause", closingCause); // This field is not needed anymore...
                }
                conversationField.put("conversationId", conversationId);
                conversationField.put("type", type);
                conversationField.put("dialog", dialogObject);
            }
                break;
            case PARTICIPANTS_CHANGE_FIELD: {
                conversationField.put("type", type);
                conversationField.put("userId", type);
                conversationField.put("role", type);
            }
                break;
        }

        body.put(CONVERSATION_FIELD, conversationField);
        json.put(AbstractRequest.JSON_KEY_BODY, body);
    }
}
