package com.liveperson.api.request.message;


/**
 * Created by nirni on 9/7/16.
 */
public abstract class BasePublishMessage implements PublishMessage {

	public enum PublishMessageType {TEXT, FILE, JSON, FORM_INVITATION, FORM_SUBMISSION, STRUCTURED_CONTENT}

	public abstract PublishMessageType getType();

	public abstract String getMessageText();

	/**
	 * getMessageTextWithoutSpecialChars - remove invalid chars
	 * (this was for bug fix 6817) when we got special chars from the web pc
	 * like: ​ ​​​​\u200B ​​​​\u200C ​​​​\u200D  etc.
	 *
	 * @param text - the original msg
	 * @return String[] of all the links
	 */
	public String getMessageTextWithoutSpecialChars(String text) {
		text = text.replaceAll("^\\s+", "");
		text = text.replaceAll("\u200B", "");
		text = text.replaceAll("\u200C", "");
		text = text.replaceAll("\u200D", "");
		text = text.replaceAll("\uFEFF", "");

		return text;
	}
}
