package com.liveperson.api.request.message;


import com.liveperson.infra.log.LPMobileLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Maayan on 28/11/2016.
 */
public class JsonPublishMessage extends BasePublishMessage {

    private static final String TAG = JsonPublishMessage.class.getCanonicalName();

    private static final String KEY_JSON_TAG_TITLE = "title";
    private static final String KEY_JSON_TAG_DESCRIPTION = "description";
    private static final String KEY_JSON_HEADER = "message_with_url";
    private static final String KEY_JSON_TAG_IMAGE_URL = "image_url";
    private static final String KEY_JSON_TAG_MESSAGE = "original_message";
    private static final String KEY_JSON_TAG_URL = "original_url_to_parse";
    private static final String KEY_JSON_TAG_SITE_NAME = "site_name_url_to_parse";

    private String mCaption;
    private String mTitle;
    private String mDescription;
    private String mCurrentImageURL;
    private String mCurrentUrl;
    private String mSiteName;


    public JsonPublishMessage(String originalMsg, String url) {
        mCaption  = originalMsg.trim();
        mCurrentUrl = url.trim();
    }

    /**
     * Build a PublishMessage from a JSONObject
     *
     * @param jsonObject
     */
    public JsonPublishMessage(JSONObject jsonObject) {

        mTitle = jsonObject.optString(KEY_JSON_TAG_TITLE);
        mDescription = jsonObject.optString(KEY_JSON_TAG_DESCRIPTION);
        mCurrentImageURL = jsonObject.optString(KEY_JSON_TAG_IMAGE_URL);
        mCaption = jsonObject.optString(KEY_JSON_TAG_MESSAGE);
        mCurrentUrl = jsonObject.optString(KEY_JSON_TAG_URL);
        mSiteName = jsonObject.optString(KEY_JSON_TAG_SITE_NAME);
    }

    @Override
    public String getMessage() {
        JSONObject msgJson = new JSONObject();
        try {
            msgJson.put(KEY_JSON_TAG_TITLE, mTitle);
            msgJson.put(KEY_JSON_TAG_DESCRIPTION, mDescription);
            msgJson.put(KEY_JSON_TAG_IMAGE_URL, mCurrentImageURL);
            msgJson.put(KEY_JSON_TAG_MESSAGE, mCaption);
            msgJson.put(KEY_JSON_TAG_URL, mCurrentUrl);
            msgJson.put(KEY_JSON_TAG_SITE_NAME, mSiteName);
        } catch (JSONException e) {
            LPMobileLog.d(TAG, "getMessage - Can't create URL message:");
        }
        return msgJson.toString();
    }

    @Override
    public PublishMessageType getType() {
        return PublishMessageType.JSON;
    }

    @Override
    public String getMessageText() {
        return getMessageTextWithoutSpecialChars(mCaption);
    }

    public String getCaption() {
        return mCaption;
    }

}
