package com.liveperson.api.response.types;

import android.text.TextUtils;

/**
 * Created by oferd on 8/10/15.
 */
public enum ConversationState {
    CLOSE,
    LOCKED,
    OPEN,
    PENDING,
    QUEUED;

    public static ConversationState parse(int ordinal) {
        ConversationState[] values = ConversationState.values();
        ConversationState result = CLOSE;

        if (values.length > ordinal) {
            result = values[ordinal];
        }
        return result;
    }


    public static ConversationState parse(String name) {
        if (TextUtils.isEmpty(name)) return CLOSE;

        ConversationState[] values = ConversationState.values();
        ConversationState result = CLOSE;
        for (ConversationState conversationState : values) {
            if (conversationState.name().equals(name)) {
                result = conversationState;
            }
        }

        return result;
    }

    public static ConversationState parse(DialogState state) {
        if (state == null) return CLOSE;
        return parse(state.name());
    }
}
